import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { preparePortalContainer, mountComponentWithStore, ReactWrapper } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsPagePortal, AnalyticsPagePortalProps } from './analytics-page.portal';

describe('AnalyticsPagePortal', () => {
    let wrapper: ReactWrapper;

    beforeEach(() => {
        preparePortalContainer();
    });

    const getManageDashboardsButton = () => wrapper.find(DotButton);

    const mount = (props: AnalyticsPagePortalProps) => {
        wrapper = mountComponentWithStore(<AnalyticsPagePortal {...props} />);
    };

    it('should render buttons when link is available', () => {
        mount({ buttonHref: 'my link' });
        const buttonManageDashboards = getManageDashboardsButton();
        expect(buttonManageDashboards).toExist();
        expect(buttonManageDashboards).toIncludeText('Manage dashboards');
    });

    it('should not render button when link is not available', () => {
        mount({ buttonHref: undefined });
        expect(getManageDashboardsButton()).not.toExist();
    });
});
