import { put, select, delay, call } from 'redux-saga/effects';
import { registerSidebarProvider, SidebarProvider } from '../../../../../../../../../../core/xlr-ui/app/features/custom-ui/sidebar.registry';
import { navigation } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { getAnalyticsStateDashboard } from '../../ducks/analytics.reducer';
import { AnalyticsCardData } from '../../types';

const { setBackItem, updateBreadcrumbs, setSidebarMenu, setLastBreadcrumb } = navigation.actions;

export function* getSelectedDashboard(): Generator<unknown, AnalyticsCardData, AnalyticsCardData> {
    const selectedDashboard: AnalyticsCardData = yield select(getAnalyticsStateDashboard);
    if (!selectedDashboard) {
        yield delay(1000); // without delay this goes into infinite loop
        return yield call(getSelectedDashboard);
    }
    return selectedDashboard;
}

export class AnalyticsSidebarProvider implements SidebarProvider {
    isSupported(path: string): boolean {
        return path.startsWith('/analytics/');
    }

    *provide(_path: string) {
        const selectedDashboard: AnalyticsCardData = yield call(getSelectedDashboard);
        const breadcrumbs = [
            { text: 'Analytics', href: `/analytics` },
            {
                text: selectedDashboard.title,
            },
        ];
        yield put(setLastBreadcrumb(undefined));
        yield put(updateBreadcrumbs(breadcrumbs));
        yield put(setSidebarMenu({ sidebarMenu: [], withFolder: false }));

        yield put(
            setBackItem({
                pathSuffix: 'analytics',
                title: 'Analytics',
                text: 'Analytics',
            }),
        );
    }
}

registerSidebarProvider(new AnalyticsSidebarProvider(), 0);
