import React from 'react';
import { DotCard, DotCardContent, DotCardFooter, DotSkeleton } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsCardSkeleton } from './analytics-card.skeleton';

describe('AnalyticsCardSkeleton', () => {
    let wrapper: ReactWrapper;

    const getSkeletonCard = () => wrapper.find(DotCard);
    const getSkeletonCardContent = () => wrapper.find(DotCardContent);
    const getSkeletonCardFooter = () => wrapper.find(DotCardFooter);

    beforeEach(() => {
        wrapper = mountWithTheme(<AnalyticsCardSkeleton />);
    });

    it('should render skeleton cards', () => {
        const card = getSkeletonCard();
        expect(card).toExist();
        expect(card.props().className).toBe('analytics-card');

        const cardContent = getSkeletonCardContent();
        expect(cardContent).toExist();
        expect(cardContent.props().className).toBe('card-content');

        const contentSkeletons = cardContent.find(DotSkeleton);
        expect(contentSkeletons.length).toBe(4);

        const footerSkeleton = getSkeletonCardFooter().find(DotSkeleton).at(0);
        expect(footerSkeleton).toExist();
        const footerSkeletonProps = footerSkeleton.props();
        expect(footerSkeletonProps.height).toBe('40px');
        expect(footerSkeletonProps.variant).toBe('rectangular');
        expect(footerSkeletonProps.width).toBe('100px');
    });
});
