import React from 'react';
import { DotCoreApiProvider, DotMetadataApiProvider } from '@digital-ai/dot-components';
import { AnalyticsAuthProvider, EVERY_MINUTE } from './analytics-auth-provider.component';
import { analytics } from '../../ducks/analytics.reducer';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';

const { refreshToken } = analytics.actions;

describe('AnalyticsAuthProvider', () => {
    let wrapper: ReactWrapper;

    const dispatch = jest.fn();
    const defaultState = {
        analytics: {
            tokenValue: 'test-token',
            intelligenceConfiguration: { url: 'http://test-url' },
        },
    };

    const mount = (state = defaultState) => {
        wrapper = mountWithStoreAndTheme(<AnalyticsAuthProvider>{<div>Child Component</div>}</AnalyticsAuthProvider>, dispatch, state);
    };

    beforeEach(() => {
        dispatch.mockReset();
    });

    it('should not render providers when intelligenceConfiguration is not present', () => {
        mount({ analytics: { tokenValue: 'test-token' } } as never);
        expect(wrapper.find(DotCoreApiProvider)).not.toExist();
        expect(wrapper.find(DotMetadataApiProvider)).not.toExist();
    });

    it('should render DotCoreApiProvider and DotMetadataApiProvider when intelligenceConfiguration is present', () => {
        mount();
        expect(wrapper.find(DotCoreApiProvider)).toExist();
        expect(wrapper.find(DotMetadataApiProvider)).toExist();
    });

    it('should dispatch refreshToken action every minute', () => {
        jest.useFakeTimers();
        mount();
        jest.advanceTimersByTime(EVERY_MINUTE);
        expect(dispatch).toHaveBeenCalledWith(refreshToken());
        expect(dispatch).toHaveBeenCalledTimes(1);
        jest.advanceTimersByTime(EVERY_MINUTE);
        expect(dispatch).toHaveBeenCalledTimes(2);
    });

    it('should clear interval on unmount', () => {
        jest.useFakeTimers();
        mount();
        jest.advanceTimersByTime(EVERY_MINUTE);
        expect(dispatch).toHaveBeenCalledTimes(1);
        wrapper.unmount();
        jest.advanceTimersByTime(EVERY_MINUTE);
        expect(dispatch).toHaveBeenCalledTimes(1);
    });
});
