/* istanbul ignore file */

import React, { useEffect } from 'react';
import { httpPOST } from '@xlr-ui/app/features/common/services/http';
import { useAppDispatch, useAppSelector } from '@xlr-ui/app/js/hooks';
import { getAnalyticsState } from '../../../ducks/analytics.reducer';
import { Folder } from '@xlr-ui/app/types';
import { useMicrostrategyContext } from './microstrategy.provider';
import { EmbedConfig } from '../../../types';
import ToastrFactory from '@xlr-ui/app/js/util/toastrFactory';
import { useCloseSidebar } from '@xlr-ui/app/features/common/hooks';
import { getNavigationState } from '@xlr-ui/app/features/main-navigation/ducks/navigation.selectors';

interface MicrostrategyDashboardProps {
    embedConfig: EmbedConfig;
    folder?: Folder;
    serverUrl: string;
}

const toastr = ToastrFactory();
const DASHBOARD_ELEMENT_ID = 'dashboard-placeholder';

export const MicrostrategyDashboard = ({ embedConfig, folder, serverUrl }: MicrostrategyDashboardProps) => {
    const { menuIsOpen } = useAppSelector(getNavigationState);
    const { intelligenceConfiguration, selectedDashboard, tokenValue } = useAppSelector(getAnalyticsState);
    const microstrategyContext = useMicrostrategyContext();
    useCloseSidebar(menuIsOpen, useAppDispatch());

    useEffect(() => {
        microstrategyContext?.mstrLogin(serverUrl);
    }, []);

    useEffect(() => {
        if (microstrategyContext?.mstrToken || microstrategyContext?.mstrError) {
            if (microstrategyContext?.mstrError) {
                toastr.warning(microstrategyContext.mstrError.message);
            }
            const scriptNode = addEmbeddinglib();
            return () => {
                document.body.removeChild(scriptNode);
            };
        }
    }, [microstrategyContext?.mstrToken, microstrategyContext?.mstrError]);

    const addEmbeddinglib = () => {
        const script = document.createElement('script');
        script.async = false;
        script.defer = false;
        document.body.appendChild(script);
        script.onload = () => {
            createDossier();
        };
        script.src = `${serverUrl}/Library/javascript/embeddinglib.js`;
        return script;
    };

    const propsForDashboard = () => {
        const filters = [];
        if (selectedDashboard?.folderFilter && folder?.id) {
            filters.push({
                key: selectedDashboard.folderFilter.key,
                selections: [
                    {
                        id: `h${folder.id};${selectedDashboard.folderFilter.source.id}`,
                    },
                ],
            });
        }
        return {
            ...embedConfig,
            placeholder: document.getElementById(DASHBOARD_ELEMENT_ID) as HTMLDivElement,
            getLoginToken: microstrategyContext?.mstrToken ? async () => microstrategyContext.mstrToken : async () => await getToken(),
            customAuthenticationType: microstrategyContext?.mstrToken
                ? window.microstrategy.dossier.CustomAuthenticationType.AUTH_TOKEN
                : window.microstrategy.dossier.CustomAuthenticationType.IDENTITY_TOKEN,
            filters,
        };
    };

    const createDossier = async () => {
        try {
            await window.microstrategy.dossier.create(propsForDashboard());
        } catch (err) {
            // TODO
        }
    };

    const getToken = async () => {
        const baseUrl = `api/extension/intelligence/token?serverId=${intelligenceConfiguration?.id}`;
        const response = await httpPOST(baseUrl, { accessToken: tokenValue });
        return response.data.entity;
    };

    return <div id={DASHBOARD_ELEMENT_ID}></div>;
};
