import React from 'react';
import { ReactWrapper } from 'enzyme';
import noop from 'lodash/noop';
import { mountWithStoreAndTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FolderExternalDeploymentsState, initialState } from '../../../ducks/external-deployments.reducer';
import { PatchModal } from './patch-modal-component';
const dispatch = jest.fn();

describe('PatchModal component', () => {
    let wrapper: ReactWrapper;
    const defaultProps = {
        onModalUpdateAutomatically: () => noop(),
        onModalUpdateManually: () => noop(),
        isModalOpen: true,
    };
    const defaultState = {
        ...initialState,
    };
    const mountComponent = (state: FolderExternalDeploymentsState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<PatchModal {...defaultProps} />, dispatch, { folderExternalDeployments: state });
    };

    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    const searchDotDialog = (selector: string) => wrapper.find(`.patch-dialog ${selector}`);

    it('should show the dialog title, collapsed body and buttons', () => {
        expect(searchDotDialog('.dot-typography').at(0).text()).toStrictEqual('Patch available');
        expect(searchDotDialog('.patch-dialog-body p.dot-typography').at(0).text()).toStrictEqual(
            'ArgoCD applications need to subscribe to Release notification webhooks if you wish to receive live updates from ArgoCD.',
        );
        expect(searchDotDialog('.patch-dialog-body p.dot-typography').at(1).text()).toStrictEqual(
            'You can choose to update it manually or automatically. How would you like to proceed?',
        );
        expect(searchDotDialog('.patch-details-collapse p').at(0).text()).toStrictEqual('Learn more..');
        expect(searchDotDialog('.dot-dialog-actions button').at(0).text()).toStrictEqual('Update Manually');
        expect(searchDotDialog('.dot-dialog-actions button').at(1).text()).toStrictEqual('Update Automatically');
    });

    it('should show the dialog title, extended body and buttons', () => {
        searchDotDialog('.patch-details-collapse p').at(0).simulate('click');

        expect(searchDotDialog('.dot-typography').at(0).text()).toStrictEqual('Patch available');
        expect(searchDotDialog('.patch-dialog-body p.dot-typography').at(0).text()).toStrictEqual(
            'ArgoCD applications need to subscribe to Release notification webhooks if you wish to receive live updates from ArgoCD.',
        );
        expect(searchDotDialog('.patch-dialog-body p.dot-typography').at(1).text()).toStrictEqual(
            'You can choose to update it manually or automatically. How would you like to proceed?',
        );
        expect(searchDotDialog('.patch-dialog-body .patch-details p.dot-typography').at(0).text()).toStrictEqual(
            'ArgoCD Application.yaml files will be patched with following annotations:',
        );
        expect(searchDotDialog('.patch-dialog-body .patch-details h4.dot-typography').at(0).text()).toStrictEqual('Annotations');
        expect(searchDotDialog('.patch-dialog-body .patch-details p.dot-typography').at(1).text()).toStrictEqual(
            '' +
                'notifications.argoproj.io/subscribe.on-created.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-deleted.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-health-unknown.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-health-progressing.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-health-suspended.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-health-healthy.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-health-degraded.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-health-missing.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-sync-unknown.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-sync-synced.release-webhook: "" ' +
                'notifications.argoproj.io/subscribe.on-sync-out-of-sync.release-webhook: ""',
        );
        expect(searchDotDialog('.patch-details-collapse p').at(0).text()).toStrictEqual('Collapse');
        expect(searchDotDialog('.dot-dialog-actions button').at(0).text()).toStrictEqual('Update Manually');
        expect(searchDotDialog('.dot-dialog-actions button').at(1).text()).toStrictEqual('Update Automatically');
    });
});
