export const EVENT_TYPE = {
    applicationPackageCreated: 'application-package-created',
    applicationPackageDeleted: 'application-package-deleted',
    applicationChanged: 'application-changed',
    applicationCreated: 'application-created',
    applicationDeleted: 'application-deleted',
};

export const SSE_REGISTRATION_URL = '/sse/application-status/register';

const DEPLOY_ENDPOINT_TYPE = 'xldeploy.XLDeployServer' as const;
const ARGOCD_ENDPOINT_TYPE = 'argocd.ArgoCD' as const;

export declare type SupportedServerType = typeof DEPLOY_ENDPOINT_TYPE | typeof ARGOCD_ENDPOINT_TYPE;

export const ENDPOINT_TYPE = {
    deploy: DEPLOY_ENDPOINT_TYPE,
    argoCd: ARGOCD_ENDPOINT_TYPE,
};

export const IMG_SRC = {
    argoCd: 'static/@project.version@/include/external-deployments/assets/argocd.svg',
    deploy: 'static/@project.version@/include/external-deployments/assets/deploy-with-background.svg',
    environment: 'static/@project.version@/include/external-deployments/assets/environment.svg',
    webhookSource: 'static/@project.version@/include/external-deployments/assets/webhook-source.svg',
};

export const APPLICATION_COLUMN_ID = 'applicationName';
export const DESTINATION_COLUMN_ID = 'environment';
export const VERSION_COLUMN_ID = 'version';
export const STATUS_COLUMN_ID = 'status';
export const TIME_COLUMN_ID = 'updated';

export const APPLICATION_ORDER_BY = 'APPLICATION';
export const DESTINATION_ORDER_BY = 'DESTINATION';
export const VERSION_ORDER_BY = 'VERSION';
export const STATUS_ORDER_BY = 'STATUS';
export const TIME_ORDER_BY = 'TIME';

export const DEFAULT_MAX_AGE = 60000;
export const MAX_AGE_NO_CACHE = 0;

export const SERVER_AUTHENTICATION_METHOD = {
    none: 'None',
    basic: 'Basic',
    ntlm: 'Ntlm',
    oauth2: 'OAuth2',
};

export const SERVER_AUTHENTICATION_OPTIONS = [
    {
        id: SERVER_AUTHENTICATION_METHOD.none,
        title: SERVER_AUTHENTICATION_METHOD.none,
    },
    {
        id: SERVER_AUTHENTICATION_METHOD.basic,
        title: SERVER_AUTHENTICATION_METHOD.basic,
    },
    {
        id: SERVER_AUTHENTICATION_METHOD.ntlm,
        title: SERVER_AUTHENTICATION_METHOD.ntlm,
    },
    {
        id: SERVER_AUTHENTICATION_METHOD.oauth2,
        title: SERVER_AUTHENTICATION_METHOD.oauth2,
    },
];

export const ENDPOINT_AUTHENTICATION_METHOD = {
    noAuth: 'events.NoAuthentication',
    tokenAuth: 'events.TokenAuthentication',
    githubAuth: 'github.GithubAuthentication',
    githubJythonAuth: 'github.GithubJythonAuthentication',
    jythonScriptAuth: 'events.JythonScriptAuthentication',
};

export const EVENT_SOURCE_AUTH_OPTIONS = [
    {
        id: ENDPOINT_AUTHENTICATION_METHOD.noAuth,
        title: 'No authentication',
    },
    {
        id: ENDPOINT_AUTHENTICATION_METHOD.tokenAuth,
        title: 'Token authentication',
    },
    {
        id: ENDPOINT_AUTHENTICATION_METHOD.githubAuth,
        title: 'Github authentication',
    },
    {
        id: ENDPOINT_AUTHENTICATION_METHOD.githubJythonAuth,
        title: 'Github authentication (Jython)',
    },
    {
        id: ENDPOINT_AUTHENTICATION_METHOD.jythonScriptAuth,
        title: 'Scripted authentication (Jython)',
    },
];
export const DEFAULT_CONDITION = '';
export const DEFAULT_ORDER = 'asc';
export const DEFAULT_ORDER_BY = STATUS_COLUMN_ID;
export const DEFAULT_PAGE = 0;
export const DEFAULT_RESULTS_PER_PAGE = 10;
