package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.v1.ManagedApplicationApi
import com.xebialabs.xlrelease.api.v1.views.{ManagedApplicationPage, ManagedApplicationView}
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagementService
import org.springframework.stereotype.Controller

import java.lang

@Controller
class ManagedApplicationApiImpl(
                                    applicationsManagementService: ApplicationsManagementService
                                   ) extends ManagedApplicationApi{

  override def getManagedApplications(folderId: String, page: lang.Long, resultsPerPage: lang.Long): ManagedApplicationPage =
    applicationsManagementService.getManagedApplications(folderId, page, resultsPerPage)

  override def deleteManagedApplication(managedApplicationId: String): Unit =
    applicationsManagementService.deleteManagedApplication(managedApplicationId)

  override def addManagedApplication(managedApplication: ManagedApplicationView): ManagedApplicationView =
    applicationsManagementService.addManagedApplication(managedApplication)

  override def updateManagedApplication(managedApplication: ManagedApplicationView): ManagedApplicationView =
    applicationsManagementService.updateManagedApplication(managedApplication)
}
