package com.xebialabs.xlrelease.status.service.script

import com.codahale.metrics.annotation.Timed
import com.fasterxml.jackson.core.`type`.TypeReference
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService
import com.xebialabs.xlrelease.script.XlrScriptContext
import com.xebialabs.xlrelease.script.jython.{JythonScriptService, XlrJythonSupport}
import com.xebialabs.xlrelease.status.service.script.PatchScriptExecutor.createPatchScriptContext
import com.xebialabs.xlrelease.status.webhook.events.{RemoteStatusWebhookEventSource, StatusWebhookEventSource}
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

trait PatchScriptService {
  @throws(classOf[Exception])
  def executeScript(eventSource: StatusWebhookEventSource): AnyRef
}

@Component
class PatchScriptExecutor(
                                    val scriptService: JythonScriptService,
                                    runnerScriptService: RunnerScriptService
                                  ) extends XlrJythonSupport with PatchScriptService with Logging {

  @Timed
  @throws(classOf[Exception])
  override def executeScript(connection: StatusWebhookEventSource): AnyRef = {
    logger.debug(s"Executing patch script for StatusWebhookEventSource ${connection.getName}")
    if (connection.isInstanceOf[RemoteStatusWebhookEventSource]) {
      runnerScriptService.executeScript[AnyRef](
        connection.patchScript,
        buildDefaultInputParams(connection),
        new TypeReference[AnyRef] {}
      )
    } else {
      val scriptContext = createPatchScriptContext(connection)
      executeScript(scriptContext)
      scriptContext.getAttribute("data")
    }
  }
}

private class PatchScriptContextBuilder(connection: StatusWebhookEventSource) extends BaseScriptContextBuilder(connection) {

  override val scriptProperty: String = PatchScriptProperty

  override protected def doBuild(context: XlrScriptContext): Unit = {
    addConnectionServerAttributes(context)
    addConnectionAttributes(context)
    addScript(context)
  }
}

private object PatchScriptExecutor {
  def createPatchScriptContext(connection: StatusWebhookEventSource): XlrScriptContext = {
    new PatchScriptContextBuilder(connection).build()
  }
}
