import moment from 'moment';
import {
    BaseExternalDeploymentEvent,
    ConnectionServer,
    DeploymentState,
    ExternalDeployment,
    SaveWebhookSourceFiltersRequest,
    Server,
    SetupLiveUpdateRequest,
    WebhookEndpoint,
    WebhookSource,
    WebhookSourceAutoConfigDetails,
    WebhookSourceFilter,
} from '../external-deployment.types';
import { ENDPOINT_TYPE } from '../constants';

export const baseExternalDeploymentEventMock: BaseExternalDeploymentEvent = {
    applicationName: 'application',
    applicationPath: 'application/path',
    applicationUid: '12',
    destination: 'Environment',
    destinationUid: '24',
    namespace: 'namespace',
};

export const baseExternalDeploymentEventMockDeploy: BaseExternalDeploymentEvent = {
    applicationName: 'application',
    applicationPath: 'application/path',
    applicationUid: '12',
    destination: 'Environment',
    destinationUid: '24',
    namespace: '',
};

export const deploymentStateWithoutDateTimeMock: DeploymentState = {
    ...baseExternalDeploymentEventMock,
    deploymentStatus: 'DONE',
    deploymentType: 'INITIAL',
    destination: 'Environment',
    user: 'admin',
    versionTag: { label: '1.0' },
};

export const deploymentStateWithoutDateTimeMockDeploy: DeploymentState = {
    ...baseExternalDeploymentEventMockDeploy,
    deploymentStatus: 'DONE',
    deploymentType: 'INITIAL',
    destination: 'Environment',
    user: 'admin',
    versionTag: { label: '1.0' },
};

export const deploymentStateMock: DeploymentState = {
    ...deploymentStateWithoutDateTimeMock,
    lastChangeTime: moment().toDate(),
};

export const deploymentStateMockDeploy: DeploymentState = {
    ...deploymentStateWithoutDateTimeMockDeploy,
    lastChangeTime: moment().toDate(),
};

export const connectionDeployServerMock: ConnectionServer = {
    id: 'Configuration/Xl Deploy',
    name: 'Xl Deploy',
    type: ENDPOINT_TYPE.deploy,
    url: 'http://localhost:4516',
};

export const connectionArgoServerMock: ConnectionServer = {
    id: 'Configuration/Argo',
    name: 'Argo',
    type: ENDPOINT_TYPE.argoCd,
    url: 'http://localhost:4516',
};

export const connectionServersMock = new Map(Object.entries({ 12: connectionDeployServerMock }));

export const externalDeploymentMock: ExternalDeployment = {
    applicationName: 'application',
    applicationPath: 'application/path',
    applicationUid: '12',
    endpointId: '12',
    state: deploymentStateMock,
    statusGroup: 'success',
};

export const externalDeploymentMockDeploy: ExternalDeployment = {
    applicationName: 'application',
    applicationPath: 'application/path',
    applicationUid: '12',
    endpointId: '12',
    state: deploymentStateMockDeploy,
    statusGroup: 'success',
};

export const deployServerMock: Server = {
    authenticationMethod: 'Basic',
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configuratione1bf86a7a9a84273bbb5f47700a9f8b8',
    title: 'Deploy',
    type: ENDPOINT_TYPE.deploy,
    url: 'http://localhost:4516',
    username: 'admin',
    variableMapping: new Map<string, string>(),
};

export const argoServerMock: Server = {
    authenticationMethod: 'None',
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configuration25659094964d443c9349b4bace63d6e8',
    title: 'ArgoCD',
    type: 'argocd.ArgoCD',
    url: 'https://localhost:7775',
    username: 'admin',
    variableMapping: new Map<string, string>(),
};

export const mockServers = [argoServerMock, deployServerMock];

export const mockSetupLiveUpdateRequest: SetupLiveUpdateRequest = {
    folderId: 'Applications/FolderSamplesAndTutorials',
    serverId: 'Configuration/Custom/Configuratione1bf86a7a9a84273bbb5f47700a9f8b8',
};

export const mockArgoWebhookSource: WebhookSource = {
    consumerEnabled: true,
    eventSource: 'Configuration/Custom/Configuration8117ebd367ae473ba5ab48f1e281c90b',
    filteredApplications: ['guestbook'],
    filteredFolders: ['digitalai'],
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configurationa263c597b7734f49960b8417c8278d72',
    sourceServer: 'Configuration/Custom/Configuration25659094964d443c9349b4bace63d6e8',
    title: 'ArgoCD',
    type: 'argocd.StatusWebhookEventSource',
    variableMapping: new Map<string, string>(),
};

export const mockDeployWebhookSource: WebhookSource = {
    consumerEnabled: true,
    eventSource: 'Configuration/Custom/Configurationd50e23fc5317443abd7bb07939e31513',
    filteredApplications: ['myapp'],
    filteredFolders: ['Applications/dir1'],
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configuration1682004056084295907f2e9c654f049b',
    sourceServer: 'Configuration/Custom/Configuratione1bf86a7a9a84273bbb5f47700a9f8b8',
    title: 'Deploy',
    type: 'xldeploy.StatusWebhookEventSource',
    variableMapping: new Map<string, string>(),
};

export const mockWebhookSources = [mockArgoWebhookSource, mockDeployWebhookSource];

export const mockConfigDetails: WebhookSourceAutoConfigDetails = {
    success: true,
    message: 'message',
    details: 'details',
    url: 'https://docs.xebialabs.com/',
    webhookSourceId: mockArgoWebhookSource.id || '',
};

export const mockWebhookSourceFilters: WebhookSourceFilter = {
    webhookSourceId: 'Configuration/Custom/Configuration1682004056084295907f2e9c654f049b',
    folderFilterOptions: ['Applications', 'Applications/dir1', 'Applications/dir2'],
    folderFilterValues: ['Applications/dir1'],
};

export const mockSaveWebhookSourceFiltersRequest: SaveWebhookSourceFiltersRequest = {
    webhookSourceId: 'Configuration/Custom/Configuration1682004056084295907f2e9c654f049b',
    filteredFolders: ['Applications/dir1', 'Applications/dir2'],
};

export const mockDeployWebhookEventSource: WebhookEndpoint = {
    id: 'Configuration/Custom/Configuration6033be04d1cd4c1cbfff74fd692632ba',
    type: 'events.PostWebhookEndpoint',
    folderId: 'Applications/FolderSamplesAndTutorials',
    title: 'Deploy',
    variableMapping: new Map<string, string>(),
    sourceEnabled: true,
    path: 'path-319973ed-b200-4b1f-8f9f-468c758f84a7',
    authentication: {
        id: 'Configuration/Custom/Configuration6033be04d1cd4c1cbfff74fd692632ba/authentication',
        type: 'events.NoAuthentication',
    },
    requestRetention: 100,
};
