package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.v1.ManagedApplicationApi
import com.xebialabs.xlrelease.api.v1.views.{ManagedApplicationPage, ManagedApplicationView}
import com.xebialabs.xlrelease.applications.management.security.ManagedApplicationPermissionChecker
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagementService
import org.springframework.stereotype.Controller

import java.lang

@Controller
class ManagedApplicationApiImpl(applicationsManagementService: ApplicationsManagementService,
                                permissions: ManagedApplicationPermissionChecker
                               ) extends ManagedApplicationApi {

  override def getManagedApplications(folderId: String, page: lang.Long, resultsPerPage: lang.Long, condition: String): ManagedApplicationPage = {
    permissions.checkViewAppPipelinesPermission(folderId)
    applicationsManagementService.getManagedApplications(folderId, page, resultsPerPage, condition)
  }

  override def getManagedApplication(managedApplicationId: String): ManagedApplicationView = {
    permissions.checkViewAppPipelinesPermission(applicationsManagementService.getManagedApplication(managedApplicationId).folderId)
    applicationsManagementService.getManagedApplication(managedApplicationId)
  }

  override def deleteManagedApplication(managedApplicationId: String): Unit = {
    permissions.checkManageAppPipelinesPermission(applicationsManagementService.getManagedApplication(managedApplicationId).folderId)
    applicationsManagementService.deleteManagedApplication(managedApplicationId)
  }

  override def addManagedApplication(managedApplication: ManagedApplicationView): ManagedApplicationView = {
    permissions.checkManageAppPipelinesPermission(managedApplication.getFolderId)
    applicationsManagementService.addManagedApplication(managedApplication)
  }

  override def updateManagedApplication(managedApplication: ManagedApplicationView): ManagedApplicationView = {
    permissions.checkManageAppPipelinesPermission(managedApplication.getFolderId)
    applicationsManagementService.updateManagedApplication(managedApplication)
  }

  override def createManagedApplicationsFromWebhookSource(webhookSourceId: String, folderId: String): Unit = {
    permissions.checkManageAppPipelinesPermission(folderId)
    applicationsManagementService.createManagedApplicationsFromWebhookSource(webhookSourceId, folderId)
  }
}
