package com.xebialabs.xlrelease.status.service.script

import com.fasterxml.jackson.core.`type`.TypeReference
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService
import com.xebialabs.xlrelease.script.XlrScriptContext
import com.xebialabs.xlrelease.script.jython.{JythonScriptService, XlrJythonSupport}
import com.xebialabs.xlrelease.status.service.script.ExternalDeploymentScriptExecutor._
import com.xebialabs.xlrelease.status.webhook.events.{RemoteStatusWebhookEventSource, StatusWebhookEventSource, UpdateStatusEvent}
import grizzled.slf4j.Logging
import io.micrometer.core.annotation.Timed
import org.springframework.stereotype.Component

import java.util

trait ExternalDeploymentScriptService {
  @throws(classOf[Exception])
  def executeScript(eventSource: StatusWebhookEventSource): AnyRef
}

@Component
class ExternalDeploymentScriptExecutor(
                            val scriptService: JythonScriptService,
                            runnerScriptService: RunnerScriptService
                          ) extends XlrJythonSupport
  with ExternalDeploymentScriptService
  with Logging {

  @Timed
  @throws(classOf[Exception])
  override def executeScript(connection: StatusWebhookEventSource): AnyRef = {
    logger.debug(s"Executing status script for StatusWebhookEventSource ${connection.getName}")
    if (connection.isInstanceOf[RemoteStatusWebhookEventSource]) {
      runnerScriptService.executeScript[util.List[UpdateStatusEvent]](
        connection.statusScript,
        buildDefaultInputParams(connection),
        new TypeReference[util.List[UpdateStatusEvent]] {}
      )
    } else {
      val scriptContext = createStatusScriptContext(connection)
      executeScript(scriptContext)
      scriptContext.getAttribute("data")
    }
  }
}

private class StatusScriptContextBuilder(connection: StatusWebhookEventSource) extends BaseScriptContextBuilder(connection) {

  override val scriptProperty: String = StatusScriptProperty

  override protected def doBuild(context: XlrScriptContext): Unit = {
    addConnectionAttributes(context)
    addConnectionServerAttributes(context)
    addScript(context)
  }
}

private object ExternalDeploymentScriptExecutor {
  def createStatusScriptContext(connection: StatusWebhookEventSource): XlrScriptContext = {
    new StatusScriptContextBuilder(connection).build()
  }
}
