import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { FolderExternalDeploymentsState } from './external-deployments.reducer';
import {
    ConnectionServer,
    ExternalDeployment,
    ExternalDeploymentPage,
    Server,
    WebhookSource,
    WebhookSourceAutoConfigDetails,
    WebhookSourceFilter,
    WebhookEndpoint,
} from '../external-deployment.types';
import { PluginInfo } from '../components/wizard/basic-wizard/application-discovery-basic.component';

export const getFolderExternalDeployments = (state: RootState): FolderExternalDeploymentsState => state.folderExternalDeployments;
export const getConnectionServersSelector = (state: RootState): Map<string, ConnectionServer> => getFolderExternalDeployments(state).connectionServers;
export const getExternalDeploymentsSelector = (state: RootState): Array<ExternalDeployment> => getFolderExternalDeployments(state).externalDeployments;
export const getExternalDeploymentPageSelector = (state: RootState): ExternalDeploymentPage => getFolderExternalDeployments(state).page;
export const getExternalDeploymentCountSelector = (state: RootState): number => getFolderExternalDeployments(state).count;
export const getIsLoadingSelector = (state: RootState): boolean => getFolderExternalDeployments(state).isLoading;
export const getConfigDetailsSelector = (state: RootState): WebhookSourceAutoConfigDetails | undefined => getFolderExternalDeployments(state).configDetails;
export const getWebhookSourcesSelector = (state: RootState): Array<WebhookSource> => getFolderExternalDeployments(state).webhookSources;
export const getServersSelector = (state: RootState): Array<Server> => getFolderExternalDeployments(state).servers;
export const getWebhookSourceFiltersSelector = (state: RootState): WebhookSourceFilter | undefined => getFolderExternalDeployments(state).webhookSourceFilters;
export const getFilterEventSourceSelector = (state: RootState): WebhookEndpoint | undefined => getFolderExternalDeployments(state).filterEventSource;
export const getConditionSelector = (state: RootState): string => getFolderExternalDeployments(state).condition;
export const getConnectionErrorsSelector = (state: RootState): Array<string> => getFolderExternalDeployments(state).connectionErrors;
export const getDisconnectedServers = (state: RootState): Array<string> => getFolderExternalDeployments(state).disconnectedServers;
export const getPreSelectedServer = (state: RootState): Server | undefined => getFolderExternalDeployments(state).preSelectedServer;
export const getValidServerCards = (state: RootState): Array<PluginInfo> => getFolderExternalDeployments(state).validServerCards;
