import React from 'react';
import { DEFAULT_APPLICATION_SEARCH_CATEGORY } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/constants';
import { ApplicationManagementState, initialState } from '../../ducks/managed-application.reducer';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { workflowStateMock } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/mocks';
import { ApplicationsPageWrapper } from './applications-page-wrapper.component';
import { ApplicationsPageComponent } from '../applications-page/applications-page.component';
import { workflow } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/ducks/workflow.reducer';

const { init } = workflow.actions;

describe('ApplicationsPageWrapper', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const folder = { id: 'folderId', title: 'Folder' };

    const mountComponent = (state: ApplicationManagementState = initialState) => {
        wrapper = mountWithStoreAndTheme(<ApplicationsPageWrapper folder={folder} />, dispatch, {
            applicationManagement: state,
            workflow: workflowStateMock,
        });
    };
    const openDrawer = () => wrapper.find(ApplicationsPageComponent).invoke('setCreateApplicationView')(true);

    it('should open the drawer', () => {
        mountComponent();
        openDrawer();
        expect(dispatch).toHaveBeenCalledWith(init({ categories: [DEFAULT_APPLICATION_SEARCH_CATEGORY] }));
    });
});
