package com.xebialabs.xlrelease.api.internal;

import java.util.Map;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import org.springframework.data.domain.Page;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.internal.views.ExternalDeploymentOrderDirection;
import com.xebialabs.xlrelease.api.internal.views.ExternalDeploymentOrderMode;
import com.xebialabs.xlrelease.api.internal.views.WebhookBasicSetupView;
import com.xebialabs.xlrelease.domain.environments.LiveDeployment;
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection;
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource;

@Path("/live-deployment")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface ExternalDeploymentApi extends ApiService {

    default String serviceName() {
        return "externalDeploymentApi";
    }

    @GET
    Map<StatusHttpConnection, String> getConnectionErrors(@QueryParam("folderId") String folderId,
                                                          @DefaultValue("0") @QueryParam("max-age") Long maxAge);

    @GET
    @Path("/page")
    Page<LiveDeployment> getLiveDeployments(
            @QueryParam("folderId") String folderId,
            @DefaultValue("0") @QueryParam("max-age") Long maxAge,
            @DefaultValue("0") @QueryParam(PAGE) Integer page,
            @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Integer resultsPerPage,
            @DefaultValue("STATUS") @QueryParam(ORDER_BY) ExternalDeploymentOrderMode orderBy,
            @DefaultValue("ASC") @QueryParam("order") ExternalDeploymentOrderDirection direction,
            @DefaultValue("") @QueryParam("condition") String condition
    );

    @PUT
    @Path("/filters/{webhookSourceId:.*/Configuration[^/]*}")
    StatusWebhookEventSource saveWebhookSourceFilters(@PathParam("webhookSourceId") String webhookSourceId);

    @POST
    @Path("/setup/{configId:.*/Configuration[^/]*}")
    WebhookBasicSetupView setupApplicationStatusWebhook(
            @PathParam("configId") String configId,
            @QueryParam("folderId") String folderId
    );

    @DELETE
    @Path("/delete/{webhookSourceId:.*/Configuration[^/]*}")
    void deleteWebhook(@PathParam("webhookSourceId") String webhookSourceId);

    @POST
    @Path("/patch/{webhookSourceId:.*/Configuration[^/]*}")
    void patchExternalDeployments(@PathParam("webhookSourceId") String webhookSourceId);

    @GET
    @Path("/count")
    Integer countLiveDeployments(
            @QueryParam("folderId") String folderId,
            @DefaultValue("") @QueryParam("condition") String condition
    );
}
