package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.domain.configuration.HttpConnection
import com.xebialabs.xlrelease.domain.environments.LiveDeploymentConfig
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import jakarta.ws.rs.core.MediaType
import jakarta.ws.rs.{Consumes, POST, Path, Produces}
import org.springframework.stereotype.Controller

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Path("/live-deployment-config")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
trait LiveDeploymentConfigResource {
  @POST
  def getLiveDeploymentConfigs(configIds: JList[String]): JList[LiveDeploymentConfig]

  @POST
  @Path("/servers")
  def getLiveDeploymentConfigServers(configIds: JList[String]): JList[HttpConnection]
}

@Controller
class LiveDeploymentConfigResourceImpl(configurationRepository: ConfigurationRepository)
  extends LiveDeploymentConfigResource {
  override def getLiveDeploymentConfigs(configIds: JList[String]): JList[LiveDeploymentConfig] = {
    Option(configIds)
      .filterNot(_.isEmpty)
      .map(ids => configurationRepository.findByIds[LiveDeploymentConfig](ids.asScala.toSeq))
      .getOrElse(List().asJava)
  }

  override def getLiveDeploymentConfigServers(configIds: JList[String]): JList[HttpConnection] = {
    Option(configIds).filterNot(_.isEmpty)
      .map(ids =>
        configurationRepository.findByIds[LiveDeploymentConfig](ids.asScala.toSeq).asScala
          .flatMap(config => Option(config.getTargetServer))
          .toList.asJava
      ).getOrElse(List().asJava)
  }
}

