package com.xebialabs.xlrelease.status.webhook.events

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.domain.environments.LiveDeploymentConfig
import com.xebialabs.xlrelease.webhooks.consumers.BaseProcessor

import scala.beans.BeanProperty

@Metadata(virtual = true, label = "Status Webhook Event Source abstract type")
class StatusWebhookEventSource extends BaseProcessor {

  @BeanProperty
  @Property(hidden = true, required = false, label="Filter script location")
  var filterScript: String = ""

  @BeanProperty
  @Property(hidden = true, required = false, label="Script location")
  var mapScript: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Status script location")
  var statusScript: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Autoconfig script location")
  var autoconfigScript: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Filters request script location")
  var filtersRequest: String = ""

  @BeanProperty
  @Property(required = true, hidden = true, description = "Patch script location")
  var patchScript: String = ""

  @BeanProperty
  @Property(label = "Live deployment configuration", description = "Configuration that defines filtering for this source", required = true)
  var config: LiveDeploymentConfig = _
}
