import React from 'react';
import { ReactWrapper } from 'enzyme';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ApplicationsPageComponent, ApplicationsPageProps } from './applications-page.component';
import { ApplicationManagementState, initialState } from '../../ducks/managed-application.reducer';
import { workflowStateMock } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/mocks';

const dispatch = jest.fn();
describe('ApplicationsPageComponent component', () => {
    const setCreateApplicationViewMock = jest.fn();
    const onViewChangeMock = jest.fn();

    let wrapper: ReactWrapper;
    const defaultProps = {
        onViewChange: onViewChangeMock,
        setCreateApplicationView: setCreateApplicationViewMock,
    };

    const mountComponent = (props: ApplicationsPageProps = defaultProps, state: ApplicationManagementState = initialState) => {
        wrapper = mountWithStoreAndTheme(<ApplicationsPageComponent {...props} />, dispatch, {
            applicationManagement: state,
            workflow: workflowStateMock,
        });
    };

    afterEach(() => {
        jest.resetAllMocks();
        wrapper.unmount();
    });

    const getCreateApplicationButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props().className === 'applications-create-btn');

    const searchDotCard = (selector: string) => wrapper.find(`.applications-placeholder ${selector}`);

    it('should show the title and description', () => {
        mountComponent();
        expect(searchDotCard('.applications-title').text()).toStrictEqual('External applications');
        expect(searchDotCard('.applications-description').text()).toContain(
            'Getting started with your applications. Create new applications in Argo CD or Digital.ai Deploy.',
        );
    });

    it('should show the create button', () => {
        mountComponent();
        expect(searchDotCard('.applications-buttons button').at(0).text()).toStrictEqual('Create application');
    });

    it("should set application view to 'true' when 'Create application' button has been clicked", () => {
        mountComponent();
        getCreateApplicationButton().invoke('onClick')();
        expect(setCreateApplicationViewMock).toHaveBeenLastCalledWith(true);
    });
});
