import React from 'react';
import { DotButton, DotIcon } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { Folder } from '../../../../../../../../../core/xlr-ui/app/types';
import { useAppDispatch } from '../../../../../../../../../core/xlr-ui/app/js/hooks';
import { folderExternalDeployments } from '../ducks/external-deployments.reducer';

export interface ApplicationsTableComponentPortalProp {
    folder: Folder;
    reSyncEnabled: boolean;
}

const { refreshExternalDeployments } = folderExternalDeployments.actions;

export const ExternalDeploymentComponentPortal = (props: ApplicationsTableComponentPortalProp) => {
    const { reSyncEnabled } = props;

    const dispatch = useAppDispatch();

    return (
        <ActionToolbarPortalContainer>
            <DotButton disabled={!reSyncEnabled} onClick={() => dispatch(refreshExternalDeployments())} startIcon={<DotIcon iconId="sync" />} type="outlined">
                Re-sync
            </DotButton>
        </ActionToolbarPortalContainer>
    );
};
