import React from 'react';
import { DotCheckboxGroup, DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { DeploymentServerSearch } from '../../ducks/deployment-server.reducer';
import { DeploymentServerConnectionFilters, DeploymentServerConnectionFiltersProps } from './deployment-server-connection-filters.component';
import { mockArgoConnectionServerMetadata, mockDeployConnectionServerMetadata } from '../../__mocks__/deployment-server.mocks';

describe('DeploymentServerConnectionFilters', () => {
    let wrapper: ReactWrapper;
    const onConnectionFilterChange = jest.fn();
    const connections = [mockDeployConnectionServerMetadata, mockArgoConnectionServerMetadata];
    const deploymentServerSearch: DeploymentServerSearch = {
        connectionServers: ['argo.ArgoCD'],
    };
    const checkBoxOptions = [
        { checked: false, label: 'Deploy', value: 'digitalai.Deploy' },
        { checked: false, label: 'ArgoCD', value: 'argocd.ArgoCD' },
    ];

    const defaultProps: DeploymentServerConnectionFiltersProps = {
        connectionServers: connections,
        deploymentServerSearch,
        isLoadingConnectionServers: false,
        onConnectionServersFilterChange: onConnectionFilterChange,
    };

    const getTitleTypography = () => wrapper.findWhere((node) => node.is(DotTypography) && node.props()['data-testid'] === 'connection-filter-title');
    const getDotCheckboxGroup = () => wrapper.find(DotCheckboxGroup);

    const mount = (props = defaultProps) => {
        wrapper = mountWithTheme(<DeploymentServerConnectionFilters {...props} />);
    };

    afterEach(() => jest.resetAllMocks());

    it('should render component with correct elements', () => {
        mount();
        const title = getTitleTypography();
        expect(title.exists()).toBe(true);
        expect(title.props().variant).toBe('subtitle2');

        const dotCheckboxGroup = getDotCheckboxGroup();
        expect(dotCheckboxGroup.exists()).toBe(true);
        const dotCheckboxGroupProps = dotCheckboxGroup.props();
        expect(dotCheckboxGroupProps.className).toBe('connections-filter');
        expect(dotCheckboxGroupProps.defaultValues).toStrictEqual([]);
        expect(dotCheckboxGroupProps.options).toStrictEqual(checkBoxOptions);
        expect(dotCheckboxGroupProps.showSelectAll).toBe(true);
    });

    it('should execute correct handler when changing categories filter', () => {
        mount();
        const options = [checkBoxOptions[0]]; // Fix: Use the correct index for checkBoxOptions
        const dotCheckboxGroup = getDotCheckboxGroup();
        dotCheckboxGroup.invoke('onChange')?.({} as never, options);
        expect(onConnectionFilterChange).toHaveBeenCalledWith(options);
    });
});
