import React, { ReactElement } from 'react';
import { mountWithTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { LiveDeploymentConfigComponentPortal, LiveDeploymentConfigComponentPortalProp } from './live-deployment-config-component.portal';
import { ActionToolbarPortalContainer } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';

describe('LiveDeploymentConfigComponentPortal', () => {
    const mockFolder: Folder = { id: '1', title: 'Test Folder' };
    const onAddClickMock = jest.fn();

    const mountComponent = (props: LiveDeploymentConfigComponentPortalProp) => mountWithTheme(<LiveDeploymentConfigComponentPortal {...props} />);

    it('should render properly', () => {
        const wrapper = mountComponent({ folder: mockFolder, onAddClick: onAddClickMock });

        const actionToolbar = wrapper.find(ActionToolbarPortalContainer);
        expect(actionToolbar).toExist();

        const button = React.Children.toArray(actionToolbar.props().children)[0] as ReactElement;
        expect(button.props.children).toBe('Add');
    });

    it('should call onAddClick with true when button is clicked', () => {
        const wrapper = mountComponent({ folder: mockFolder, onAddClick: onAddClickMock });

        const actionToolbar = wrapper.find(ActionToolbarPortalContainer);
        const button = React.Children.toArray(actionToolbar.props().children)[0] as ReactElement;
        button.props.onClick();
        expect(onAddClickMock).toHaveBeenCalledWith(true);
    });
});
