import React from 'react';
import { DotSkeleton, DotCard } from '@digital-ai/dot-components';
import { mockResizeObserver, mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ExternalDeploymentCardSkeletonComponent } from './external-deployment-card-skeleton.component';

describe('ExternalDeploymentCardSkeletonComponent', () => {
    const mountComponent = () => mountWithTheme(<ExternalDeploymentCardSkeletonComponent />);

    const getDotCard = (wrapper: ReactWrapper) => wrapper.find(DotCard);
    const getSkeletonWithClass = (wrapper: ReactWrapper, className: string) =>
        wrapper.findWhere((node) => node.is(DotSkeleton) && node.props().className === className);

    const getTitleSkeleton = (wrapper: ReactWrapper) => wrapper.findWhere((node) => node.is(DotSkeleton) && node.props()['data-testid'] === 'title-skeleton');

    beforeEach(() => {
        mockResizeObserver();
    });

    it('should render properly', () => {
        const wrapper = mountComponent();

        const card = getDotCard(wrapper);
        expect(card).toExist();
        expect(card.props().className).toBe('external-deployment-card-skeleton-wrapper');

        const avatarSkeleton = getSkeletonWithClass(wrapper, 'avatar-skeleton');
        expect(avatarSkeleton).toExist();
        expect(avatarSkeleton.props().variant).toBe('circular');

        const titleSkeleton = getTitleSkeleton(wrapper);
        expect(titleSkeleton).toExist();
        expect(titleSkeleton.props().width).toBe('100%');
        expect(titleSkeleton.props().variant).toBeUndefined();

        const contentLineSkeletons = getSkeletonWithClass(wrapper, 'card-content-line-skeleton');
        expect(contentLineSkeletons).toExist();
        expect(contentLineSkeletons).toHaveLength(7);
        contentLineSkeletons.forEach((lineSkeleton) => expect(lineSkeleton.props().variant).toBe('text'));
    });
});
