import { folderExternalDeployments, initialState } from './external-deployments.reducer';
import { LiveDeploymentData, ExternalDeploymentPage, ExternalDeploymentEvent, Server, Environment, Application } from '../external-deployment.types';
import {
    deployServerMock,
    externalDeploymentCreateEventMock,
    externalDeploymentDeleteEventMock,
    externalDeploymentUpdateEventMock,
    mockApplication,
    mockArgoWebhookSource,
    mockConfigDetails,
    mockDeployWebhookEventSource,
    mockEnvironment,
    mockLiveDeploymentData,
    mockSaveWebhookSourceFiltersRequest,
    mockServers,
    mockSetupLiveUpdateRequest,
    mockStatusWebhookEventSource,
    mockWebhookSourceFilters,
    mockWebhookSources,
    pluginInfoGeneric,
} from '../__mocks__/external-deployments.mocks';
import { ConfigurationCallbackPayload } from '@xlr-ui/app/features/configuration/types';

describe('external deployments reducer', () => {
    const {
        addServerToServers,
        addValidPluginToArray,
        createApplicationStatus,
        createServer,
        deleteApplicationStatus,
        deleteWebhookSource,
        getAvailablePlugins,
        getFilters,
        loadExternalDeployments,
        loadFilterEventSource,
        loadServers,
        loadWebhookSourceFilters,
        loadWebhookSources,
        patchExternalDeployments,
        refreshExternalDeployments,
        removeWebhookSource,
        saveEventSource,
        setCondition,
        setConfigDetails,
        setConnectionErrors,
        setLiveDeployments,
        setLiveDeploymentsCount,
        setFilterEventSource,
        setIsLoading,
        setIsTableView,
        setLiveDeploymentsPreconditionFilter,
        setLiveUpdate,
        setMaxAge,
        setPage,
        setPreSelectedServer,
        setServers,
        setWebhookSourceFilters,
        setWebhookSources,
        storeFilters,
        subscribeToSseStream,
        unsubscribeFromSseStream,
        updateApplicationStatus,
        updateBreadcrumbs,
        updateServerList,
        updateWebhookSourceFilters,
        setStatusWebhookEventSources,
        setConnectionServers,
        setDisconnectedServers,
        setEnvironments,
        setApplications,
    } = folderExternalDeployments.actions;

    it('should have the initial state', () => {
        expect(folderExternalDeployments.name).toBe('folderExternalDeployments');
        expect(folderExternalDeployments.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('createApplicationStatus', () => {
            it('should not update state', () => {
                const payload: ExternalDeploymentEvent = {
                    ...externalDeploymentCreateEventMock,
                };
                const state = folderExternalDeployments.reducer(initialState, createApplicationStatus(payload));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('createServer', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, createServer(deployServerMock));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('deleteApplicationStatus', () => {
            it('should not update state', () => {
                const payload: ExternalDeploymentEvent = {
                    ...externalDeploymentDeleteEventMock,
                };
                const state = folderExternalDeployments.reducer(initialState, deleteApplicationStatus(payload));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('loadExternalDeployments', () => {
            it('should not update state', () => {
                const state = folderExternalDeployments.reducer(initialState, loadExternalDeployments());
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('refreshExternalDeployments', () => {
            it('should not update state', () => {
                const state = folderExternalDeployments.reducer(initialState, refreshExternalDeployments());
                expect(state).toStrictEqual(state);
            });
        });

        describe('loadServers', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, loadServers('SomeConfigurationId'));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('loadWebhookSources', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, loadWebhookSources('SomeConfigurationId'));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('loadWebhookSourceFilters', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, loadWebhookSourceFilters('SomeConfigurationId'));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('setConnectionErrors', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, setConnectionErrors(['someConnectionError']));
                expect(state.connectionErrors).toStrictEqual(['someConnectionError']);
            });
        });

        describe('setConfigDetails', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, setConfigDetails(mockConfigDetails));
                expect(state).toStrictEqual({ ...initialState, configDetails: mockConfigDetails });
            });
        });

        describe('setLiveDeployments', () => {
            it('should update state', () => {
                const payload: Array<LiveDeploymentData> = [mockLiveDeploymentData];
                const state = folderExternalDeployments.reducer(initialState, setLiveDeployments(payload));
                expect(state.liveDeployments).toStrictEqual(payload);
            });
        });

        describe('setExternalDeploymentsCount', () => {
            it('should update state', () => {
                const payload = 100;
                const state = folderExternalDeployments.reducer(initialState, setLiveDeploymentsCount(payload));
                expect(state.count).toStrictEqual(payload);
            });
        });

        describe('setIsLoading', () => {
            it('should update state', () => {
                const payload = true;
                const state = folderExternalDeployments.reducer(initialState, setIsLoading(payload));
                expect(state.isLoading).toStrictEqual(payload);
            });
        });

        describe('setIsTableView', () => {
            it('should update state', () => {
                const payload = false;
                const state = folderExternalDeployments.reducer(initialState, setIsTableView(payload));
                expect(state.isTableView).toStrictEqual(payload);
            });
        });

        describe('setMaxAge', () => {
            it('should update state', () => {
                const payload = 20;
                const state = folderExternalDeployments.reducer(initialState, setMaxAge(payload));
                expect(state.maxAge).toStrictEqual(payload);
            });
        });

        describe('setPreSelectedServer', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, setPreSelectedServer(deployServerMock));
                expect(state).toStrictEqual({ ...initialState, preSelectedServer: deployServerMock });
            });
        });

        describe('setServers', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, setServers(mockServers));
                expect(state).toStrictEqual({ ...initialState, servers: mockServers });
            });
        });

        describe('setLiveUpdate', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, setLiveUpdate(mockSetupLiveUpdateRequest));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('setWebhookSources', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, setWebhookSources(mockWebhookSources));
                expect(state).toStrictEqual({ ...initialState, webhookSources: mockWebhookSources });
            });
        });

        describe('setWebhookSourceFilters', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, setWebhookSourceFilters(mockWebhookSourceFilters));
                expect(state).toStrictEqual({ ...initialState, webhookSourceFilters: mockWebhookSourceFilters });
            });
        });

        describe('addServerToServers', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, addServerToServers(deployServerMock));
                expect(state).toStrictEqual({ ...initialState, servers: [deployServerMock] });
            });
        });

        describe('subscribeToSseStream', () => {
            it('should not update state', () => {
                const state = folderExternalDeployments.reducer(initialState, subscribeToSseStream());
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('updateApplicationStatus', () => {
            it('should not update state', () => {
                const payload: ExternalDeploymentEvent = {
                    ...externalDeploymentUpdateEventMock,
                };
                const state = folderExternalDeployments.reducer(initialState, updateApplicationStatus(payload));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('updateWebhookSourceFilters', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, updateWebhookSourceFilters(mockSaveWebhookSourceFiltersRequest));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('unsubscribeFromSseStream', () => {
            it('should not update state', () => {
                const state = folderExternalDeployments.reducer(initialState, unsubscribeFromSseStream());
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('deleteWebhookSource', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, deleteWebhookSource('SomeConfigurationId'));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('removeWebhookSource', () => {
            it('should update state', () => {
                const mockDeployWebhookSourceId = 'Configuration/Custom/Configuration1682004056084295907f2e9c654f049b';
                const state = folderExternalDeployments.reducer(
                    {
                        ...initialState,
                        webhookSources: mockWebhookSources,
                    },
                    removeWebhookSource(mockDeployWebhookSourceId),
                );
                expect(state).toStrictEqual({ ...initialState, webhookSources: [mockArgoWebhookSource] });
            });
        });

        describe('loadFilterEventSource', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, loadFilterEventSource('SomeConfigurationId'));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('setFilterEventSource', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, setFilterEventSource(mockDeployWebhookEventSource));
                expect(state).toStrictEqual({ ...initialState, filterEventSource: mockDeployWebhookEventSource });
            });
        });

        describe('saveEventSource', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, saveEventSource(mockDeployWebhookEventSource));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('setCondition', () => {
            it('should update state', () => {
                const payload = 'condition';
                const state = folderExternalDeployments.reducer(initialState, setCondition(payload));
                expect(state.condition).toStrictEqual(payload);
            });
        });

        describe('setPage', () => {
            it('should update state', () => {
                const payload: ExternalDeploymentPage = {
                    folderId: 'folder-1',
                    order: 'asc',
                    orderBy: 'environment',
                    page: 1,
                    resultsPerPage: 10,
                };
                const state = folderExternalDeployments.reducer(initialState, setPage(payload));
                expect(state.page).toStrictEqual(payload);
            });
        });

        describe('storeFilters', () => {
            it('should not update state', () => {
                const state = folderExternalDeployments.reducer(initialState, storeFilters());
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('getFilters', () => {
            it('should update state', () => {
                const payload = 'folder-1';
                const state = folderExternalDeployments.reducer(initialState, getFilters(payload));
                expect(state.page.folderId).toStrictEqual(payload);
            });
        });

        describe('patchExternalDeployments', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, patchExternalDeployments('SomeConfigurationId'));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('updateBreadcrumbs', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(initialState, updateBreadcrumbs({ id: 'folderId', title: 'Folder' }));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('updateServerList', () => {
            it('should do nothing with state', () => {
                const payload: ConfigurationCallbackPayload = {
                    id: '',
                    isUpdate: false,
                    keyOrName: '',
                    type: '',
                };
                const state = folderExternalDeployments.reducer(initialState, updateServerList(payload));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('addValidPluginToArray', () => {
            it('should update state', () => {
                const state = folderExternalDeployments.reducer(initialState, addValidPluginToArray(pluginInfoGeneric));
                expect(state.validServerCards[0]).toStrictEqual(pluginInfoGeneric);
            });
        });

        describe('getAvailablePlugins', () => {
            it('should not update state', () => {
                const payload = 'argoCD';
                const state = folderExternalDeployments.reducer(initialState, getAvailablePlugins(payload));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('setLiveDeploymentsPreconditionFilter', () => {
            it('should do nothing with state', () => {
                const state = folderExternalDeployments.reducer(
                    initialState,
                    setLiveDeploymentsPreconditionFilter({ folderId: 'folderId', applicationName: 'app' }),
                );
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('setStatusWebhookEventSources', () => {
            it('should update state', () => {
                const payload = [mockStatusWebhookEventSource];
                const state = folderExternalDeployments.reducer(initialState, setStatusWebhookEventSources(payload));
                expect(state.statusWebhookEventSources).toStrictEqual(payload);
            });
        });

        describe('setLiveDeploymentsCount', () => {
            it('should update state', () => {
                const payload = 5;
                const state = folderExternalDeployments.reducer(initialState, setLiveDeploymentsCount(payload));
                expect(state.count).toStrictEqual(payload);
            });
        });

        describe('setConnectionServers', () => {
            it('should update state', () => {
                const payload = new Map<string, Server>().set('serverId', deployServerMock);
                const state = folderExternalDeployments.reducer(initialState, setConnectionServers(payload));
                expect(state.connectionServers).toStrictEqual(payload);
            });
        });

        describe('setDisconnectedServers', () => {
            it('should update state', () => {
                const payload = ['serverId'];
                const state = folderExternalDeployments.reducer(initialState, setDisconnectedServers(payload));
                expect(state.disconnectedServers).toStrictEqual(payload);
            });
        });

        describe('setEnvironments', () => {
            it('should update state', () => {
                const payload = new Map<string, Environment>().set('envId', mockEnvironment);
                const state = folderExternalDeployments.reducer(initialState, setEnvironments(payload));
                expect(state.environments).toStrictEqual(payload);
            });
        });

        describe('setApplications', () => {
            it('should update state', () => {
                const payload = new Map<string, Application>().set('envId', mockApplication);
                const state = folderExternalDeployments.reducer(initialState, setApplications(payload));
                expect(state.applications).toStrictEqual(payload);
            });
        });
    });
});
