import React from 'react';
import { CssCell, CssGrid } from '@digital-ai/dot-components';

import { mountWithTheme, mockResizeObserver, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { ExternalDeploymentsCardsSkeletonComponent } from './external-deployments-cards-skeleton.component';
import { ExternalDeploymentCardSkeletonComponent } from './external-deployment-card-skeleton.component';

describe('ExternalDeploymentsCardsSkeletonComponent', () => {
    const mountComponent = () => mountWithTheme(<ExternalDeploymentsCardsSkeletonComponent />);
    const getSkeletonsCard = (wrapper: ReactWrapper) => wrapper.find('div.external-deployments-cards-skeletons');

    beforeEach(() => {
        mockResizeObserver();
    });

    it('should render properly', () => {
        const wrapper = mountComponent();

        const cards = getSkeletonsCard(wrapper);
        expect(cards).toExist();
        expect(cards).toHaveLength(1);

        cards.forEach((card) => {
            const cssGrid = card.find(CssGrid);
            expect(cssGrid).toExist();

            const cssCells = cssGrid.find(CssCell);
            expect(cssCells).toExist();
            expect(cssCells).toHaveLength(4);

            cssCells.forEach((cssCell) => {
                const cardSkeleton = cssCell.find(ExternalDeploymentCardSkeletonComponent);
                expect(cardSkeleton).toExist();
            });
        });
    });
});
