package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.domain.environments.Application
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository
import jakarta.ws.rs._
import jakarta.ws.rs.core.MediaType
import org.springframework.stereotype.Controller

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Path("/application-source")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
trait ApplicationSourceResource {

  @POST
  def getApplications(applicationIds: JList[String]): JList[Application]

  @GET
  @Path("{applicationId:.+}")
  def getApplication(@PathParam("applicationId") applicationId: String): Application

  @GET
  @Path("/folder/{folderId:.+}")
  def getApplicationsByFolderId(@PathParam("folderId") folderId: String): JList[Application]
}

@Controller
class ApplicationSourceResourceImpl(applicationRepository: ApplicationRepository) extends ApplicationSourceResource {

  override def getApplications(applicationIds: JList[String]): JList[Application] = {
    applicationRepository.fetchApplications(applicationIds.asScala.toList).asJava
  }

  override def getApplication(applicationId: String): Application = {
    applicationRepository.findApplicationById(applicationId)
  }

  override def getApplicationsByFolderId(folderId: String): JList[Application] = {
    applicationRepository.fetchApplicationsByFolderId(folderId).asJava
  }
}
