import moment from 'moment';
import {
    Application,
    DeploymentState,
    Environment,
    ExternalDeploymentEvent,
    StatusWebhookEventSource,
    LiveDeploymentData,
    LiveDeploymentsPreconditionFilter,
    PluginInfo,
    SaveWebhookSourceFiltersRequest,
    Server,
    ServerCi,
    SetupLiveUpdateRequest,
    WebhookEndpoint,
    WebhookSource,
    WebhookSourceAutoConfigDetails,
    WebhookSourceFilter,
} from '../external-deployment.types';
import { ENDPOINT_TYPE } from '../constants';

export const deploymentStateMock: DeploymentState = {
    id: 'DeploymentState4194f0fa020348b08bcfd809f5cf2ad3',
    type: 'xlrelease.DeploymentState',
    lastChangeTime: moment().toDate(),
    status: 'DONE',
    statusGroup: 'success',
    deploymentLink: 'http://localhost:4516/deployment-link',
    user: 'admin',
    versionTag: '1.0',
    versionState: 'Synced',
    versionTooltip: '1.0',
    versionLink: 'http://localhost:4516/version-link',
};

export const mockLiveDeploymentData: LiveDeploymentData = {
    application: 'Configuration/environmentManagement/Application94fc0b1d48414eb9863678de60e15c8f',
    deploymentState: deploymentStateMock,
    environment: 'Configuration/environmentManagement/Environment0c8d3788649b4861b12e6bdfad2d185f',
    eventSourceId: 'Configuration/Custom/Configurationf83e3c16bce142d0a316cd35a780affb',
    folderId: 'FolderSamplesAndTutorials',
    id: 'DeploymentStatef4d72fe382f24c67a446a3965c68fd47',
    type: 'xlrelease.DeploymentState',
};

export const externalDeploymentUpdateEventMock: ExternalDeploymentEvent = {
    deploymentId: 'DeploymentStatef4d72fe382f24c67a446a3965c68fd47',
    data: mockLiveDeploymentData,
};

export const externalDeploymentCreateEventMock: ExternalDeploymentEvent = {
    deploymentId: 'DeploymentStatef4d72fe382f24c67a446a3965c68fd47',
    data: mockLiveDeploymentData,
};

export const externalDeploymentDeleteEventMock: ExternalDeploymentEvent = {
    deploymentId: 'DeploymentStatef4d72fe382f24c67a446a3965c68fd47',
};

export const mockApplication: Application = {
    applicationSource: {
        applicationPath: '/#/explorer?ciId=Applications/todo-dir/TodoApp',
        id: 'ApplicationSource5a17dc4965fe41ee9b81d10031fd25e8',
        type: 'deploy.DeployApplicationSource',
        serverUrl: 'http://localhost:4516',
        targetRevision: '1.0',
    },
    correlationUid: 'd8bbed29-ef29-4610-ae84-4dfea09b016c',
    environments: ['Configuration/environmentManagement/Environment0471fe50ea29481d873ae18bdb3247ad'],
    folderId: 'FolderSamplesAndTutorials',
    id: 'Configuration/environmentManagement/Application94fc0b1d48414eb9863678de60e15c8f',
    title: 'TodoApp',
    type: 'xlrelease.Application',
};

export const mockEnvironment: Environment = {
    correlationUid: '1b36e06c-623d-4e60-8edb-b7c2b51c3452',
    deploymentTarget: {
        id: 'DeploymentTargetf4d72fe382f24c67a446a3965c68fd47',
        type: 'deploy.DeployDeploymentTarget',
        targetUrl: 'http://localhost:4516',
        environmentPath: 'http://localhost:4516/#/explorer?ciId=Environments/todo-dir/dev',
    },
    folderId: 'FolderSamplesAndTutorials',
    id: 'Configuration/environmentManagement/Environment0c8d3788649b4861b12e6bdfad2d185f',
    labels: [],
    stage: 'Configuration/environmentManagement/EnvironmentStage6c52f70302af4af8b65063573637d42f',
    title: 'dev',
    type: 'xlrelease.Environment',
};

export const mockStatusWebhookEventSource: StatusWebhookEventSource = {
    folderId: 'FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configurationf83e3c16bce142d0a316cd35a780affb',
    sourceServer: 'Configuration/Custom/Configuratione1bf86a7a9a84273bbb5f47700a9f8b8',
    title: 'Deploy',
    type: 'digitalai.DeployDeployment',
};

export const deployServerMock: Server = {
    authenticationMethod: 'Basic',
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configuratione1bf86a7a9a84273bbb5f47700a9f8b8',
    title: 'Deploy',
    type: ENDPOINT_TYPE.deploy,
    url: 'http://localhost:4516',
    username: 'admin',
    variableMapping: new Map<string, string>(),
};

export const argoServerMock: Server = {
    authenticationMethod: 'None',
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configuration25659094964d443c9349b4bace63d6e8',
    title: 'ArgoCD',
    type: 'argocd.ArgoCD',
    url: 'https://localhost:7775',
    username: 'admin',
    variableMapping: new Map<string, string>(),
};

export const mockServers = [argoServerMock, deployServerMock];

export const mockSetupLiveUpdateRequest: SetupLiveUpdateRequest = {
    folderId: 'Applications/FolderSamplesAndTutorials',
    serverId: 'Configuration/Custom/Configuratione1bf86a7a9a84273bbb5f47700a9f8b8',
};

export const mockArgoWebhookSource: WebhookSource = {
    consumerEnabled: true,
    eventSource: 'Configuration/Custom/Configuration8117ebd367ae473ba5ab48f1e281c90b',
    filteredApplications: ['guestbook'],
    filteredFolders: ['digitalai'],
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configurationa263c597b7734f49960b8417c8278d72',
    sourceServer: 'Configuration/Custom/Configuration25659094964d443c9349b4bace63d6e8',
    title: 'ArgoCD',
    type: 'argocd.StatusWebhookEventSource',
    variableMapping: new Map<string, string>(),
};

export const mockDeployWebhookSource: WebhookSource = {
    consumerEnabled: true,
    eventSource: 'Configuration/Custom/Configurationd50e23fc5317443abd7bb07939e31513',
    filteredApplications: ['myapp'],
    filteredFolders: ['Applications/dir1'],
    folderId: 'Applications/FolderSamplesAndTutorials',
    id: 'Configuration/Custom/Configuration1682004056084295907f2e9c654f049b',
    sourceServer: 'Configuration/Custom/Configuratione1bf86a7a9a84273bbb5f47700a9f8b8',
    title: 'Deploy',
    type: 'xldeploy.StatusWebhookEventSource',
    variableMapping: new Map<string, string>(),
};

export const mockWebhookSources = [mockArgoWebhookSource, mockDeployWebhookSource];

export const mockConfigDetails: WebhookSourceAutoConfigDetails = {
    success: true,
    message: 'message',
    details: 'details',
    url: 'https://docs.xebialabs.com/',
    webhookSourceId: mockArgoWebhookSource.id || '',
};

export const mockWebhookSourceFilters: WebhookSourceFilter = {
    webhookSourceId: 'Configuration/Custom/Configuration1682004056084295907f2e9c654f049b',
    folderFilterOptions: ['Applications', 'Applications/dir1', 'Applications/dir2'],
    folderFilterValues: ['Applications/dir1'],
};

export const mockSaveWebhookSourceFiltersRequest: SaveWebhookSourceFiltersRequest = {
    webhookSourceId: 'Configuration/Custom/Configuration1682004056084295907f2e9c654f049b',
    filteredFolders: ['Applications/dir1', 'Applications/dir2'],
};

export const mockDeployWebhookEventSource: WebhookEndpoint = {
    id: 'Configuration/Custom/Configuration6033be04d1cd4c1cbfff74fd692632ba',
    type: 'events.PostWebhookEndpoint',
    folderId: 'Applications/FolderSamplesAndTutorials',
    title: 'Deploy',
    variableMapping: new Map<string, string>(),
    sourceEnabled: true,
    path: 'path-319973ed-b200-4b1f-8f9f-468c758f84a7',
    authentication: {
        id: 'Configuration/Custom/Configuration6033be04d1cd4c1cbfff74fd692632ba/authentication',
        type: 'events.NoAuthentication',
    },
    requestRetention: 100,
};

export const mockLiveDeploymentsPreconditionFilter: LiveDeploymentsPreconditionFilter = {
    folderId: 'Applications/FolderSamplesAndTutorials',
    applicationName: 'app1',
};

export const mockServersMap: Map<string, Server> = new Map<string, Server>(
    mockServers.map((server) => [mockStatusWebhookEventSource.id, server] as [string, Server]),
);

export const mockApplications = [mockApplication];

export const mockApplicationsMap: Map<string, Application> = new Map(mockApplications.map((app) => [app.id, app] as [string, Application]));

export const mockEnvironments = [mockEnvironment];

export const mockEnvironmentsMap: Map<string, Environment> = new Map(mockEnvironments.map((env) => [env.id, env] as [string, Environment]));

export const mockServerCi: ServerCi = {
    id: null,
    properties: deployServerMock,
    title: 'title',
    type: 'deploy.XlDeployServer',
};

export const pluginInfoGeneric: PluginInfo = {
    iconLocation: 'icon',
    isAutoconfigurable: true,
    title: 'title',
    subheader: 'subheader',
    type: 'type',
};

export const pluginInfoDeploy: PluginInfo = {
    iconLocation: 'icon',
    isAutoconfigurable: false,
    subheader: 'subheader',
    title: 'title',
    type: ENDPOINT_TYPE.deploy,
};

export const pluginInfoArgo: PluginInfo = {
    iconLocation: 'icon',
    isAutoconfigurable: true,
    subheader: 'subheader',
    title: 'title',
    type: ENDPOINT_TYPE.argoCd,
};
