import React from 'react';
import { CssCell, CssGrid } from '@digital-ai/dot-components';
import { ExternalDeploymentCardSkeletonComponent } from './external-deployment-card-skeleton.component';
import './external-deployments-cards-skeleton.component.less';

export const ExternalDeploymentsCardsSkeletonComponent = () => {
    return (
        <div className="external-deployments-cards-skeletons">
            <CssGrid
                columnsBreakpoints={{
                    xxl: 4,
                    xl: 3,
                    lg: 2,
                    md: 2,
                    sm: 1,
                    xs: 1,
                }}
                rows={'1fr 0 0 0 0 0'}
            >
                {[...Array(4)].map((_cellValue, cellIndex) => {
                    return (
                        <CssCell className="external-deployments-cards-skeletons-card-cell" key={cellIndex}>
                            <ExternalDeploymentCardSkeletonComponent />
                        </CssCell>
                    );
                })}
            </CssGrid>
        </div>
    );
};
