import React from 'react';
import { CssCell, CssGrid } from '@digital-ai/dot-components';
import { calculateCellProps, getRandomInt } from '@xlr-ui/app/features/workflow/helper';
import { DeploymentServerCardSkeleton } from './deployment-server-card-skeleton.component';
import './deployment-server-skeletons.component.less';

export const DeploymentServerSkeletons = () => {
    return (
        <>
            {[...Array(getRandomInt(1, 3))].map((_value, index) => (
                <div className="deployment-server-skeletons-card" key={index}>
                    <CssGrid>
                        {[...Array(getRandomInt(1, 3))].map((_cellValue, cellIndex) => {
                            const props = calculateCellProps(cellIndex);
                            return (
                                <CssCell {...props} key={cellIndex}>
                                    <DeploymentServerCardSkeleton />
                                </CssCell>
                            );
                        })}
                    </CssGrid>
                </div>
            ))}
        </>
    );
};
