import React from 'react';
import { DotButton, DotIcon } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '@xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { Folder } from '@xlr-ui/app/types';
import { useAppDispatch } from '@xlr-ui/app/js/hooks';
import { folderExternalDeployments } from '../ducks/external-deployments.reducer';
import { folderDeploymentServers } from '../../deployment-server/ducks/deployment-server.reducer';

export interface ApplicationsTableComponentPortalProp {
    folder: Folder;
    reSyncEnabled: boolean;
}

const { refreshExternalDeployments } = folderExternalDeployments.actions;
const { openLiveDeploymentConfiguration } = folderDeploymentServers.actions;
export const ExternalDeploymentComponentPortal = (props: ApplicationsTableComponentPortalProp) => {
    const { reSyncEnabled } = props;

    const dispatch = useAppDispatch();

    return (
        <ActionToolbarPortalContainer>
            <DotButton
                className="sync-btn"
                disabled={!reSyncEnabled}
                onClick={() => dispatch(refreshExternalDeployments())}
                startIcon={<DotIcon iconId="sync" />}
                type="outlined"
            >
                Refresh
            </DotButton>
            <DotButton
                className="conf-btn"
                onClick={() => {
                    dispatch(openLiveDeploymentConfiguration(false));
                }}
                type="primary"
            >
                Configure
            </DotButton>
        </ActionToolbarPortalContainer>
    );
};
