package com.xebialabs.xlrelease.chainofcustody.scmdata.strategy

import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMEventHandlerUtils._
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMListenerStrategy
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.repository.ReleaseRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Autowired
@Component
class ReleaseVariableHandler(
                              releaseRepository: ReleaseRepository,
                              scmTraceabilityService: SCMTraceabilityService
                            ) extends SCMListenerStrategy {

  override val updateFunction: Release => Release = releaseRepository.update

  override def isDefinedAt(event: XLReleaseEvent): Boolean = event.isInstanceOf[ReleaseVariableCreatedEvent] ||
    event.isInstanceOf[ReleaseVariableDeletedEvent] ||
    event.isInstanceOf[ReleaseVariableReplacedEvent] ||
    event.isInstanceOf[ReleaseVariablesUpdatedEvent] ||
    event.isInstanceOf[ReleaseVariableUpdatedEvent]

  override def apply(event: XLReleaseEvent): Unit = {
    val variables = event match {
      case relVariableEvent: ReleaseVariableCreatedEvent => relVariableEvent.variable :: Nil
      case relVariableEvent: ReleaseVariableDeletedEvent => relVariableEvent.variable :: Nil
      case relVariableEvent: ReleaseVariableReplacedEvent => relVariableEvent.variable :: Nil
      case relVariableEvent: ReleaseVariablesUpdatedEvent => relVariableEvent.updatedVariables.asScala.toList
      case relVariableEvent: ReleaseVariableUpdatedEvent => relVariableEvent.updated :: Nil
    }

    variables.foreach(deleteSCMDataAndUpdateRelease(_, releaseRepository.findById, updateFunction, scmTraceabilityService.persistOrDelete))
  }
}
