package com.xebialabs.xlrelease.chainofcustody.scmdata.strategy

import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMEventHandlerUtils._
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMListenerStrategy
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events.{TaskCreatedOrTypeChangedEvent, TaskDeletedEvent, TaskMovedEvent, XLReleaseEvent}
import com.xebialabs.xlrelease.repository.ReleaseRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Autowired
@Component
class TaskEventHandler(
                        releaseRepository: ReleaseRepository,
                        scmTraceabilityService: SCMTraceabilityService
                      ) extends SCMListenerStrategy {

  override val updateFunction: Release => Release = releaseRepository.update

  override def isDefinedAt(event: XLReleaseEvent): Boolean = event.isInstanceOf[TaskCreatedOrTypeChangedEvent] ||
    event.isInstanceOf[TaskDeletedEvent] ||
    event.isInstanceOf[TaskMovedEvent]

  override def apply(event: XLReleaseEvent): Unit = {
    val task = event match {
      case taskEvent: TaskCreatedOrTypeChangedEvent => taskEvent.task
      case taskEvent: TaskDeletedEvent => taskEvent.task
      case taskEvent: TaskMovedEvent => taskEvent.movedTask
    }

    deleteSCMDataAndUpdateRelease(task.getRelease, updateFunction, scmTraceabilityService.persistOrDelete)
  }
}
