package com.xebialabs.xlrelease.chainofcustody.scmdata.strategy

import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMEventHandlerUtils._
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMListenerStrategy
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.repository.ReleaseRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Autowired
@Component
class PhaseEventHandler(
                         releaseRepository: ReleaseRepository,
                         scmTraceabilityService: SCMTraceabilityService
                       ) extends SCMListenerStrategy {

  override val updateFunction: Release => Release = releaseRepository.update

  override def isDefinedAt(event: XLReleaseEvent): Boolean = event.isInstanceOf[PhaseCopiedEvent] ||
    event.isInstanceOf[PhaseCreatedEvent] ||
    event.isInstanceOf[PhaseDeletedEvent] ||
    event.isInstanceOf[PhaseDuplicatedEvent] ||
    event.isInstanceOf[PhaseMovedEvent] ||
    event.isInstanceOf[PhaseUpdatedEvent]

  override def apply(event: XLReleaseEvent): Unit = {
    val release = event match {
      case phaseEvent: PhaseCopiedEvent => phaseEvent.phaseCopy.getRelease
      case phaseEvent: PhaseCreatedEvent => phaseEvent.phase.getRelease
      case phaseEvent: PhaseDeletedEvent => phaseEvent.phase.getRelease
      case phaseEvent: PhaseDuplicatedEvent => phaseEvent.phaseDuplicate.getRelease
      case phaseEvent: PhaseMovedEvent => phaseEvent.movedPhase.getRelease
      case phaseEvent: PhaseUpdatedEvent => phaseEvent.updated.getRelease
    }

    deleteSCMDataAndUpdateRelease(release, updateFunction, scmTraceabilityService.persistOrDelete)
  }
}
