package com.xebialabs.xlrelease.chainofcustody.scmdata.strategy

import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlrelease.api.v1.TemplateApi
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMEventHandlerUtils._
import com.xebialabs.xlrelease.chainofcustody.scmdata.SCMListenerStrategy
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.repository.ReleaseRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Autowired
@Component
class ReleaseEventHandler(
                           releaseRepository: ReleaseRepository,
                           scmTraceabilityService: SCMTraceabilityService,
                           templateResource: TemplateApi
                         ) extends SCMListenerStrategy {

  override val updateFunction: Release => Release = releaseRepository.update

  override def isDefinedAt(event: XLReleaseEvent): Boolean = event.isInstanceOf[ReleaseCreatedEvent] ||
    event.isInstanceOf[ReleaseDuplicatedEvent] ||
    event.isInstanceOf[ReleaseMovedEvent] ||
    event.isInstanceOf[ReleaseUpdatedEvent]

  override def apply(event: XLReleaseEvent): Unit = {
    val release = event match {
      case relEvent: ReleaseCreatedEvent =>
        if (relEvent.source.isInstanceOf[CreatedFromTemplate]) {
          duplicateSCMData(relEvent.release, scmTraceabilityService.getById, scmTraceabilityService.persistOrDelete, updateFunction)
        }
        None
      case relEvent: ReleaseDuplicatedEvent => Some(relEvent.releaseDuplicate)
      case relEvent: ReleaseMovedEvent => Option(templateResource.getTemplate(relEvent.toReleaseId))
      case relEvent: ReleaseUpdatedEvent => Some(relEvent.updated)
    }

    release.foreach(deleteSCMDataAndUpdateRelease(_, updateFunction, scmTraceabilityService.persistOrDelete))
  }
}
