package com.xebialabs.xlrelease.chainofcustody.scmdata

import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData
import com.xebialabs.xlplatform.coc.service.PersistenceParams
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.repository.Ids
import grizzled.slf4j.Logging
// TODO to fix on REL-9301
/*
@Service
@EventListener
class SCMEventHandler @Autowired()(
                       listenerProcessors: JavaList[SCMListenerStrategy]
                     ) extends Logging {

  private val processors = listenerProcessors.reduceLeft[PartialFunction[XLReleaseEvent, Unit]]((left, right) => left.orElse(right)).orElse(
    new SCMListenerStrategy {
      override def isDefinedAt(event: XLReleaseEvent): Boolean = true

      override def apply(event: XLReleaseEvent): Unit = ()

      override val updateFunction: Release => Release = null
    }
  )

  @Subscribe
  def onEvent(event: XLReleaseEvent): Unit = processors(event)
}
*/

object SCMEventHandlerUtils {
  def deleteSCMDataAndUpdateRelease(
                                     variable: Variable,
                                     findRelease: String => Release,
                                     updateRelease: Release => _,
                                     scmPersistOrDelete: PersistenceParams => Option[Integer]
                                   ): Unit = {
    val releaseParent = Ids.getParentId(variable.getId)
    val release = findRelease(releaseParent)
    deleteSCMDataAndUpdateRelease(release, updateRelease, scmPersistOrDelete)
  }

  def deleteSCMDataAndUpdateRelease(template: Release, updateRelease: Release => _, scmPersistOrDelete: PersistenceParams => Option[Integer]): Unit = {
    val scmId = Option(template.get$ciAttributes().getScmTraceabilityDataId).filterNot(_ == 0)
    scmId.foreach { id =>
      template.get$ciAttributes().setScmTraceabilityDataId(null)
      updateRelease(template)
      scmPersistOrDelete(PersistenceParams(Some(id), None))
    }
  }

  def duplicateSCMData(
                        release: Release,
                        getSCMData: Integer => Option[SCMTraceabilityData],
                        scmPersistOrDelete: PersistenceParams => Option[Integer],
                        updateRelease: Release => _
                      ): Unit = {
    val scmId = Option(release.get$ciAttributes().getScmTraceabilityDataId).filterNot(_ == 0)
    scmId.foreach { id =>
      val scmData = getSCMData(id)
      scmPersistOrDelete(PersistenceParams(None, scmData)).foreach { scmDataNewId =>
        release.get$ciAttributes().setScmTraceabilityDataId(scmDataNewId)
        updateRelease(release)
      }
    }
  }
}

trait SCMListenerStrategy extends PartialFunction[XLReleaseEvent, Unit] with Logging {
  val updateFunction: Release => Release
}
