import { addCounterToFolders, calculateFullFolderId, mapFolders } from './helpers';
import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { HomeApplicationFolder } from '../active-application-tile.component';

describe('application tile helper functions', () => {
    const mappedFolders: { [id: string]: number } = {
        'Applications/folderId1': 1,
        'Applications/folderId2': 3,
    };

    describe('addCounterToFolders', () => {
        const allFolders: Array<Folder> = [
            {
                children: [
                    {
                        id: 'Applications/folderId10',
                        title: 'Title Inside',
                    },
                ],
                id: 'Applications/folderId1',
                title: 'Title One',
            },
            {
                id: 'Applications/folderId2',
                title: 'Title Two',
            },
        ];

        it('should return formatted folders with counter next to the title', () => {
            const foldersWithCounters: Array<Folder> = [
                {
                    children: [
                        {
                            children: undefined,
                            id: 'Applications/folderId10',
                            title: 'Title Inside (0)',
                        },
                    ],
                    id: 'Applications/folderId1',
                    title: 'Title One (1)',
                },
                {
                    children: undefined,
                    id: 'Applications/folderId2',
                    title: 'Title Two (3)',
                },
            ];

            expect(addCounterToFolders(allFolders, mappedFolders)).toStrictEqual(foldersWithCounters);
        });
    });

    describe('calculateFullFolderId', () => {
        it('should return full folder id when folder path is root', () => {
            expect(calculateFullFolderId('/', 'folderId')).toStrictEqual('Applications/folderId');
        });

        it('should return full folder id when folder path is not root', () => {
            expect(calculateFullFolderId('/folderPath', 'folderId')).toStrictEqual('Applications/folderPath/folderId');
            expect(calculateFullFolderId('/folderPath1/folderPath2', 'folderId')).toStrictEqual('Applications/folderPath1/folderPath2/folderId');
        });
    });

    describe('mapFolders', () => {
        const folders: Array<HomeApplicationFolder> = [
            {
                folderId: 'folderId1',
                folderName: 'Title One',
                folderPath: '/',
                total: 1,
            },
            {
                folderId: 'folderId2',
                folderName: 'Title Two',
                folderPath: '/',
                total: 3,
            },
        ];

        it('should return mapped folders with id and total number', () => {
            expect(mapFolders(folders)).toStrictEqual(mappedFolders);
        });

        it('should return mapped folders properly for folders that have nested folder path', () => {
            const foldersWithPath: Array<HomeApplicationFolder> = [
                {
                    folderId: 'folderId1',
                    folderName: 'Title One',
                    folderPath: '/folderPath1/folderPath2',
                    total: 1,
                },
            ];
            expect(mapFolders(foldersWithPath)).toStrictEqual({ 'Applications/folderPath1/folderPath2/folderId1': 1 });
        });
    });
});
