package com.xebialabs.xlrelease.plugins.dashboard.repository

import com.xebialabs.deployit.security.Role
import com.xebialabs.xlrelease.plugins.dashboard.domain.{Dashboard, Tile}

trait DashboardRepository {

  def exists(dashboardId: String): Boolean

  def search(parentId: String, title: String, principals: Iterable[String], roles: Iterable[Role], enforcePermissions: Boolean = true): Seq[Dashboard]

  def findDashboardById(dashboardId: String): Dashboard

  def createDashboard(dashboard: Dashboard): Dashboard

  def updateDashboard(dashboard: Dashboard): Dashboard

  def deleteDashboard(dashboardId: String): Unit

  def findTileById(tileId: String): Tile

  def updateTile(tile: Tile): Tile

  def getSecurityUid(dashboardId: String): Option[String]
}
