package com.xebialabs.xlrelease.plugins.dashboard.service

import com.xebialabs.xlrelease.domain.VariableContainer
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile
import com.xebialabs.xlrelease.variable.VariableResolver._

import scala.jdk.CollectionConverters._

object TileHelper {
  def resolveVariables(tile: Tile, parent: Option[VariableContainer], varaibles: Seq[Variable]): Tile = {
    val unresolved = resolve(tile, parent.map(_.getAllVariables.asScala.toSeq).getOrElse(Seq.empty) ++ varaibles)._1

    if (unresolved.nonEmpty) {
      throw new IllegalArgumentException(
        s"Unable to fetch data for tile '${tile.getTitle}' due to missing values for variables: ${unresolved.mkString(", ")}"
      )
    }
    tile
  }
}
