package com.xebialabs.xlrelease.plugins.dashboard

import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, DescriptorRegistry, Type}
import com.xebialabs.xlrelease.plugins.dashboard.domain.{Dashboard, Tile}
import com.xebialabs.xlrelease.repository.Ids.getName
import com.xebialabs.xlrelease.service.CiIdService
import com.xebialabs.xlrelease.utils.ListUtils._

import scala.jdk.CollectionConverters._

package object repository {

  implicit class DashboardExtensions(dashboard: Dashboard)(implicit val ciIdService: CiIdService) {
    def setNewTileIds(): Unit = {
      dashboard.getTiles
        .asScala
        .filter(t => nullId(t.getId))
        .foreach(_.setId(dashboard.newTileId))
    }

    def updateTileIds(): Unit = {
      // update default Tile IDs with new Tile IDs
      dashboard.getTiles
        .asScala
        .filter(t => t.getId.trim.toLowerCase.endsWith(t.getType.toString.toLowerCase))
        .foreach(_.setId(dashboard.newTileId))
    }

    def newTileId: String = {
      ciIdService.getUniqueId(Type.valueOf(classOf[Tile]), dashboard.getId)
    }

    def updateTile(tile: Tile): Unit = {
      dashboard.setTiles(dashboard.getTiles.asScala.toList.replace(_.getId == tile.getId, tile).asJava)
    }

    private def addTile(tileDescriptor: Descriptor): Unit = {
      val tempId = dashboard.getId + "/" + tileDescriptor.getType.toString
      updateTile(tileDescriptor.newInstance[Tile](tempId))
    }

    def addDefaultTiles(): Dashboard = {
      for {
        tileDescriptor <- DescriptorRegistry.getSubtypes(Type.valueOf(classOf[Tile])).asScala.map(_.getDescriptor)
        if !tileDescriptor.isVirtual
        if tileDescriptor.shouldBeAddedTo(dashboard)
      } addTile(tileDescriptor)
      dashboard
    }

    private def nullId(id: String): Boolean = {
      id == null || id.trim.isEmpty || id.trim.toLowerCase == "null"
    }

    implicit class TileDescriptor(tileDescriptor: Descriptor) {
      def shouldBeAddedTo(dashboard: Dashboard): Boolean = {
        Option(tileDescriptor.getPropertyDescriptor("defaultDashboards"))
          .flatMap(default => Option(default.getDefaultValue.asInstanceOf[java.util.List[String]]))
          .exists(defaultDashboards => defaultDashboards.contains(getName(dashboard.getId)) || defaultDashboards.contains(dashboard.getType.toString))
      }
    }

  }

}
