/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningConfig;
import com.xebialabs.xlrelease.scm.data.VersionInfo;
import com.xebialabs.xlrelease.scm.data.VersionsView;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService;
import com.xebialabs.xlrelease.versioning.ascode.form.CreateVersionForm;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Path(value="api/v1/folders/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001B\b\u0011\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AA\b\u0001B\u0001B\u0003%Q\bC\u0003D\u0001\u0011\u0005A\tC\u0003Z\u0001\u0011\u0005!\fC\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002P\u0002!\t!!5\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b\tAbi\u001c7eKJ4VM]:j_:Lgn\u001a*fg>,(oY3\u000b\u0005E\u0011\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005M!\u0012aA1qS*\u0011QCF\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0006\r\u0002\u0013a,'-[1mC\n\u001c(\"A\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nQa\u001d7gi)T\u0011aJ\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0006\n\u0002\b\u0019><w-\u001b8h\u0003E\u0001XM]7jgNLwN\\\"iK\u000e\\WM\u001d\t\u0003Y=j\u0011!\f\u0006\u0003]Q\t\u0001b]3dkJLG/_\u0005\u0003a5\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0003]1w\u000e\u001c3feZ+'o]5p]&twmU3sm&\u001cW\r\u0005\u00024u5\tAG\u0003\u00026m\u0005\u00191oY7\u000b\u0005]B\u0014AB1tG>$WM\u0003\u0002:)\u0005Qa/\u001a:tS>t\u0017N\\4\n\u0005m\"$a\u0006$pY\u0012,'OV3sg&|g.\u001b8h'\u0016\u0014h/[2f\u0003q1w\u000e\u001c3feZ+'o]5p]&tw-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u001c\u0002\r\u0005\u001cGo\u001c:t\u0013\t\u0011uH\u0001\u000fG_2$WM\u001d,feNLwN\\5oO\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0011)u\tS%\u0011\u0005\u0019\u0003Q\"\u0001\t\t\u000b)\"\u0001\u0019A\u0016\t\u000bE\"\u0001\u0019\u0001\u001a\t\u000bq\"\u0001\u0019A\u001f)\u0005\u0011Y\u0005C\u0001'X\u001b\u0005i%B\u0001(P\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003!F\u000bqAZ1di>\u0014\u0018P\u0003\u0002S'\u0006)!-Z1og*\u0011A+V\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta+A\u0002pe\u001eL!\u0001W'\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!C4fi\u000e{gNZ5h)\tY6\r\u0005\u0002]C6\tQL\u0003\u00028=*\u0011\u0011h\u0018\u0006\u0003AR\ta\u0001Z8nC&t\u0017B\u00012^\u0005Y1u\u000e\u001c3feZ+'o]5p]&twmQ8oM&<\u0007\"\u00023\u0006\u0001\u0004)\u0017\u0001\u00034pY\u0012,'/\u00133\u0011\u0005\u0019lgBA4l!\tAg$D\u0001j\u0015\tQ'$\u0001\u0004=e>|GOP\u0005\u0003Yz\ta\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011AN\b\u0015\u0005GF\\H\u0010\u0005\u0002ss6\t1O\u0003\u0002uk\u0006\u0011!o\u001d\u0006\u0003m^\f!a^:\u000b\u0003a\fQA[1wCbL!A_:\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017!\u0002<bYV,\u0017%\u00013)\u000b\u0015q80a\u0001\u0011\u0005I|\u0018bAA\u0001g\n!\u0001+\u0019;iC\t\t)!A\u000e0w\u001a|G\u000eZ3s\u0013\u0012TdF\u000b$pY\u0012,'o\u001700[uSSp\f\u0015\u0004\u000b\u0005%\u0001c\u0001:\u0002\f%\u0019\u0011QB:\u0003\u0007\u001d+E+\u0001\u0007va\u0012\fG/Z\"p]\u001aLw\rF\u0003\\\u0003'\t9\u0002C\u0003e\r\u0001\u0007Q\rK\u0003\u0002\u0014E\\H\u0010\u0003\u0004\u0002\u001a\u0019\u0001\raW\u0001\u0007G>tg-[4)\u000b\u0019q80a\u0001)\u0007\u0019\ty\u0002E\u0002s\u0003CI1!a\tt\u0005\r\u0001V\u000bV\u0001\rM\u0016$8\r[\"iC:<Wm\u001d\u000b\u0005\u0003S\t9\u0004\u0005\u0003\u0002,\u0005MRBAA\u0017\u0015\u0011\ty#!\r\u0002\t\u0011\fG/\u0019\u0006\u0003kQIA!!\u000e\u0002.\taa+\u001a:tS>t7OV5fo\")Am\u0002a\u0001K\"*\u0011qG9|y\"*qA`>\u0002>\u0005\u0012\u0011qH\u0001)_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018gKR\u001c\u0007.L2iC:<Wm\u001d\u0015\u0004\u000f\u0005%\u0011aC4fiZ+'o]5p]N$B!!\u000b\u0002H!)A\r\u0003a\u0001K\"*\u0011qI9|y\"*\u0001B`>\u0002N\u0005\u0012\u0011qJ\u0001$_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018wKJ\u001c\u0018n\u001c8tQ\rA\u0011\u0011B\u0001\u000eGJ,\u0017\r^3WKJ\u001c\u0018n\u001c8\u0015\r\u0005]\u0013QLA1!\u0011\tY#!\u0017\n\t\u0005m\u0013Q\u0006\u0002\f-\u0016\u00148/[8o\u0013:4w\u000eC\u0003e\u0013\u0001\u0007Q\rK\u0003\u0002^E\\H\u0010C\u0004\u0002d%\u0001\r!!\u001a\u0002\u0017Y,'o]5p]\u001a{'/\u001c\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e\u001c\u0002\t\u0019|'/\\\u0005\u0005\u0003_\nIGA\tDe\u0016\fG/\u001a,feNLwN\u001c$pe6DS!\u0003@|\u0003\u001bB3!CA;!\r\u0011\u0018qO\u0005\u0004\u0003s\u001a(\u0001\u0002)P'R\u000bA\"\u00199qYf4VM]:j_:$b!a \u0002\u0006\u0006%\u0005cA\u000f\u0002\u0002&\u0019\u00111\u0011\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006I*\u0001\r!\u001a\u0015\u0006\u0003\u000b\u000b8\u0010 \u0005\u0007\u0003\u0017S\u0001\u0019A3\u0002\u000fY,'o]5p]\"2\u0011\u0011R9|\u0003\u001f\u000b#!a#)\u000b)q80a%\"\u0005\u0005U\u0015AN\u0018|M>dG-\u001a:JIjr#FR8mI\u0016\u00148LX\u0018.;*jxF^3sg&|gn]\u0018|m\u0016\u00148/[8ou9RSpL1qa2L\bf\u0001\u0006\u0002v\u0005q\u0001O]3wS\u0016<8)\u001e:sK:$HcA3\u0002\u001e\")Am\u0003a\u0001K\"*\u0011QT9|y\"*1B`>\u0002$\u0006\u0012\u0011QU\u0001#_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018qe\u00164\u0018.Z<)\r-\tIk_AX!\r\u0011\u00181V\u0005\u0004\u0003[\u001b(\u0001\u0003)s_\u0012,8-Z:-\u0005\u0005E\u0016EAAZ\u00035!X\r\u001f;0m:$g&_1nY\"\u001a1\"!\u0003\u0002\u001dA\u0014XM^5foZ+'o]5p]R)Q-a/\u0002@\")A\r\u0004a\u0001K\"*\u00111X9|y\"1\u00111\u0012\u0007A\u0002\u0015Dc!a0rw\u0006=\u0005&\u0002\u0007\u007fw\u0006\u0015\u0017EAAd\u0003az3PZ8mI\u0016\u0014\u0018\n\u001a\u001e/U\u0019{G\u000eZ3s7z{S&\u0018\u0016~_Y,'o]5p]N|3P^3sg&|gN\u000f\u0018+{>\u0002(/\u001a<jK^Dc\u0001DAUw\u0006-GFAAYQ\ra\u0011\u0011B\u0001\u0010I\u0016dW\r^3M_\u000e\fGNU3q_R1\u0011qPAj\u0003/DQ\u0001Z\u0007A\u0002\u0015DS!a5rwrDq!!7\u000e\u0001\u0004\tY.A\u0006dYV\u001cH/\u001a:XS\u0012,\u0007cA\u000f\u0002^&\u0019\u0011q\u001c\u0010\u0003\u000f\t{w\u000e\\3b]\":\u0011q[Arw\u0006%\bc\u0001:\u0002f&\u0019\u0011q]:\u0003\u0015E+XM]=QCJ\fW.\t\u0002\u0002Z\":\u0011q[Aww\u0006M\bc\u0001:\u0002p&\u0019\u0011\u0011_:\u0003\u0019\u0011+g-Y;miZ\u000bG.^3\"\u0005\u0005U\u0018!\u00024bYN,\u0007&B\u0007\u007fw\u0006e\u0018EAA~\u00031z3PZ8mI\u0016\u0014\u0018\n\u001a\u001e/U\u0019{G\u000eZ3s7z{S&\u0018\u0016~_\u0011,G.\u001a;f[1|7-\u00197.e\u0016\u0004x\u000eK\u0002\u000e\u0003\u007f\u00042A\u001dB\u0001\u0013\r\u0011\u0019a\u001d\u0002\u0007\t\u0016cU\tV#\u0002\u001dI,7/\u001a;M_\u000e\fGNU3q_R1\u0011q\u0010B\u0005\u0005\u001bAQ\u0001\u001a\bA\u0002\u0015DSA!\u0003rwrDq!!7\u000f\u0001\u0004\tY\u000eK\u0004\u0003\u000e\u0005\r80!;)\u000f\t5\u0011Q^>\u0002t\"*aB`>\u0003\u0016\u0005\u0012!qC\u0001,_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018sKN,G/\f7pG\u0006dWF]3q_\"\u001aa\"a\b)\u0007\u0001\u0011i\u0002\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\r\u0011\u0019cU\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B\u0014\u0005C\u0011!bQ8oiJ|G\u000e\\3sQ\u0019\u0001!1F>\u00032A\u0019!O!\f\n\u0007\t=2O\u0001\u0005D_:\u001cX/\\3tY\t\u0011\u0019$\t\u0002\u00036\u0005\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\u001c\u0015\u0007\u0001\u0005%6P!\u000f-\u0005\tM\u0002&\u0002\u0001\u007fw\nu\u0012E\u0001B \u0003e\t\u0007/[\u0018wc=2w\u000e\u001c3feN|c/\u001a:tS>t\u0017N\\4")
public class FolderVersioningResource
implements Logging {
    private final PermissionChecker permissionChecker;
    private final FolderVersioningService folderVersioningService;
    private final FolderVersioningActorService folderVersioningActorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVersioningResource folderVersioningResource = this;
        synchronized (folderVersioningResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public FolderVersioningConfig getConfig(@PathParam(value="folderId") String folderId) {
        return (FolderVersioningConfig)((Object)this.folderVersioningService.findFolderVersioningConfig(folderId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public FolderVersioningConfig updateConfig(@PathParam(value="folderId") String folderId, FolderVersioningConfig config) {
        config.setFolderId(folderId);
        return this.folderVersioningService.createOrUpdateFolderVersioningConfig(config);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/fetch-changes")
    public VersionsView fetchChanges(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2 = this.folderVersioningActorService.fetchChanges(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date lastFetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lastFetched, (Object)versions);
        Tuple2 tuple23 = tuple22;
        Date lastFetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(lastFetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionsView getVersions(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2 = this.folderVersioningService.getVersions(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date fetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fetched, (Object)versions);
        Tuple2 tuple23 = tuple22;
        Date fetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(fetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionInfo createVersion(@PathParam(value="folderId") String folderId, CreateVersionForm versionForm) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        return this.folderVersioningActorService.createVersion(folderId, versionForm.name(), versionForm.description());
    }

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/apply")
    public void applyVersion(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.applyVersion(folderId, version);
    }

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/preview")
    public String previewCurrent(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.generatePreview(folderId, (Option<String>)None$.MODULE$);
    }

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/preview")
    public String previewVersion(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.generatePreview(folderId, (Option<String>)new Some((Object)version));
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/delete-local-repo")
    public void deleteLocalRepo(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="clusterWide") boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningConfig config = this.folderVersioningService.getFolderVersioningConfig(folderId);
        this.folderVersioningActorService.deleteLocalRepo(config, clusterWide);
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/reset-local-repo")
    public void resetLocalRepo(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="clusterWide") boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningConfig config = this.folderVersioningService.getFolderVersioningConfig(folderId);
        this.folderVersioningActorService.resetLocalRepo(config, clusterWide);
    }

    @Autowired
    public FolderVersioningResource(PermissionChecker permissionChecker, FolderVersioningService folderVersioningService, FolderVersioningActorService folderVersioningActorService) {
        this.permissionChecker = permissionChecker;
        this.folderVersioningService = folderVersioningService;
        this.folderVersioningActorService = folderVersioningActorService;
        Logging.$init$((Logging)this);
    }
}

