package com.xebialabs.xlrelease.environments.repository

import com.xebialabs.xlrelease.api.v1.filter.EnvironmentStageFilters
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage
import com.xebialabs.xlrelease.repository.Page

trait EnvironmentStageRepository {

  def search(filters: EnvironmentStageFilters, page: Page): Seq[EnvironmentStage]

  def findById(environmentStageId: String): EnvironmentStage

  def findByTitle(environmentStageTitle: String): EnvironmentStage

  def create(environmentStage: EnvironmentStage): EnvironmentStage

  def update(environmentStage: EnvironmentStage): EnvironmentStage

  def delete(environmentStageId: String): Unit
}
