/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011)\u0019!C\u0001a!Aq\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003N\u0001\u0011\u0005a\nC\u0003u\u0001\u0011\u0005Q\u000fC\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\t)\u0004\u0001C\u0005\u0003o\u0011!#\u00128wSJ|g.\\3oiN+'O^5dK*\u0011q\u0002E\u0001\bg\u0016\u0014h/[2f\u0015\t\t\"#\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002\u0014)\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006g24GG\u001b\u0006\u0002K\u0005AqM]5{u2,G-\u0003\u0002(E\t9Aj\\4hS:<\u0017!F3om&\u0014xN\\7f]R\u0014V\r]8tSR|'/\u001f\t\u0003U5j\u0011a\u000b\u0006\u0003YA\t!B]3q_NLGo\u001c:z\u0013\tq3FA\u000bF]ZL'o\u001c8nK:$(+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003iI\ta!\u001a<f]R\u001c\u0018B\u0001\u001c4\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtDc\u0001\u001e={A\u00111\bA\u0007\u0002\u001d!)\u0001\u0006\u0002a\u0001S!)q\u0006\u0002a\u0001c!\u0012Aa\u0010\t\u0003\u0001.k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b!\"\u00198o_R\fG/[8o\u0015\t!U)A\u0004gC\u000e$xN]=\u000b\u0005\u0019;\u0015!\u00022fC:\u001c(B\u0001%J\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u0003\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0013g\u0016\f'o\u00195F]ZL'o\u001c8nK:$8\u000f\u0006\u0002P=B\u0019\u0001+V,\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016K\u0001\u0003MSN$\bC\u0001-]\u001b\u0005I&BA\t[\u0015\tY&#\u0001\u0004e_6\f\u0017N\\\u0005\u0003;f\u00131\"\u00128wSJ|g.\\3oi\")q,\u0002a\u0001A\u0006\u0011RM\u001c<je>tW.\u001a8u\r&dG/\u001a:t!\t\t\u0007.D\u0001c\u0015\t\u0019G-\u0001\u0004gS2$XM\u001d\u0006\u0003K\u001a\f!A^\u0019\u000b\u0005\u001d\u0014\u0012aA1qS&\u0011\u0011N\u0019\u0002\u0013\u000b:4\u0018N]8o[\u0016tGOR5mi\u0016\u00148\u000f\u000b\u0002\u0006WB\u0011AN]\u0007\u0002[*\u0011!I\u001c\u0006\u0003_B\fq!\\3ue&\u001c7O\u0003\u0002r-\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002t[\n)A+[7fI\u0006\u0019b-\u001b8e\u000b:4\u0018N]8o[\u0016tGOQ=JIR\u0011qK\u001e\u0005\u0006o\u001a\u0001\r\u0001_\u0001\u000eK:4\u0018N]8o[\u0016tG/\u00133\u0011\u0007e\f\tA\u0004\u0002{}B\u00111\u0010H\u0007\u0002y*\u0011Q\u0010G\u0001\u0007yI|w\u000e\u001e \n\u0005}d\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0005\u0015!AB*ue&twM\u0003\u0002\u00009!\u0012aa[\u0001\u0012GJ,\u0017\r^3F]ZL'o\u001c8nK:$HcA,\u0002\u000e!1\u0011qB\u0004A\u0002]\u000b1\"\u001a8wSJ|g.\\3oi\"\u0012qa[\u0001\u0012kB$\u0017\r^3F]ZL'o\u001c8nK:$HcA,\u0002\u0018!1\u0011q\u0002\u0005A\u0002]C#\u0001C6\u0002#\u0011,G.\u001a;f\u000b:4\u0018N]8o[\u0016tG\u000f\u0006\u0003\u0002 \u0005\u0015\u0002cA\u000e\u0002\"%\u0019\u00111\u0005\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006o&\u0001\r\u0001\u001f\u0015\u0003\u0013-\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\u0003?\ti\u0003\u0003\u0004\u0002\u0010)\u0001\raV\u0001\u000em\u0006d\u0017\u000eZ1uKRKG\u000f\\3\u0015\t\u0005}\u00111\u0007\u0005\u0007\u0003\u001fY\u0001\u0019A,\u0002'Y\fG.\u001b3bi\u0016$Um]2sSB$\u0018n\u001c8\u0015\t\u0005}\u0011\u0011\b\u0005\u0007\u0003\u001fa\u0001\u0019A,)\u0007\u0001\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019eR\u0001\u000bgR,'/Z8usB,\u0017\u0002BA$\u0003\u0003\u0012qaU3sm&\u001cW\r")
public class EnvironmentService
implements Logging {
    private final EnvironmentRepository environmentRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentService environmentService = this;
        synchronized (environmentService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public List<Environment> searchEnvironments(EnvironmentFilters environmentFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentRepository.searchEnvironments(environmentFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Environment findEnvironmentById(String environmentId) {
        return this.environmentRepository.findEnvironmentById(environmentId);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Environment createEnvironment(Environment environment) {
        void var2_2;
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment");
        this.validate(environment);
        Environment created = this.environmentRepository.createEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentCreatedEvent(created));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Environment updateEnvironment(Environment environment) {
        void var2_2;
        this.logger().debug((Function0 & Serializable)() -> "Updating environment [" + environment + "]");
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environment);
        Environment updated = this.environmentRepository.updateEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentUpdatedEvent(environment));
        return var2_2;
    }

    @Timed
    public void deleteEnvironment(String environmentId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting environment [" + environmentId + "]");
        Environment environment = this.environmentRepository.findEnvironmentById(environmentId);
        this.environmentRepository.deleteEnvironment(environmentId);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentDeletedEvent(environment));
    }

    private void validate(Environment environment) {
        this.validateTitle(environment);
        this.validateDescription(environment);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environment.getStage()).exists((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$validate$1(stage))), (String)"Environment stage ID is required", (Object[])new Object[0]);
    }

    private void validateTitle(Environment environment) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateDescription(Environment environment) {
        block0: {
            if (environment.getDescription() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Description cannot be blank", (Object[])new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(EnvironmentStage stage) {
        return StringUtils.hasText((String)stage.getId());
    }

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, XLReleaseEventBus eventBus) {
        this.environmentRepository = environmentRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

