package com.xebialabs.xlrelease.builder

import com.xebialabs.xlrelease.domain.environments.EnvironmentStage

object EnvironmentStageBuilder {
  def newStage: EnvironmentStageBuilder = new EnvironmentStageBuilder
}

class EnvironmentStageBuilder {
  private var id: String = _
  private var title: String = _

  def withId(id: String): EnvironmentStageBuilder = {
    this.id = id
    this
  }

  def withTitle(title: String): EnvironmentStageBuilder = {
    this.title = title
    this
  }

  def build: EnvironmentStage = {
    val stage = new EnvironmentStage
    stage.setId(id)
    stage.setTitle(title)
    stage
  }
}
