package com.xebialabs.xlrelease.environments.repository.sql.persistence.builder

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.db.sql.{SqlBuilder, SqlWithParameters}
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentLabelSchema.ENV_LABELS

class EnvironmentLabelSqlBuilder(implicit dialect: Dialect) extends SqlBuilder[EnvironmentLabelSqlBuilder] {
  val envLabelAlias = "envLabel"

  private val STMT_SELECT_ENV_LABEL =
    s"""
       |SELECT
       |  $envLabelAlias.${ENV_LABELS.ID} ${ColumnAliases.EnvLabels.ID},
       |  $envLabelAlias.${ENV_LABELS.TITLE} ${ColumnAliases.EnvLabels.TITLE},
       |  $envLabelAlias.${ENV_LABELS.COLOR} ${ColumnAliases.EnvLabels.COLOR}
       |FROM ${ENV_LABELS.TABLE} $envLabelAlias
       |""".stripMargin

  override def build(): SqlWithParameters = {
    super.build()
  }

  def select(): EnvironmentLabelSqlBuilder = {
    super.select(STMT_SELECT_ENV_LABEL)
  }

  def withTitleLike(title: String): EnvironmentLabelSqlBuilder = {
    like(s"$envLabelAlias.${ENV_LABELS.TITLE}", title)
  }

  override def newInstance: EnvironmentLabelSqlBuilder = new EnvironmentLabelSqlBuilder()

}
