package com.xebialabs.xlrelease.environments.service

import com.xebialabs.deployit.checks.Checks.checkArgument
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentStageFilters
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage
import com.xebialabs.xlrelease.environments.repository.EnvironmentStageRepository
import grizzled.slf4j.Logging
import io.micrometer.core.annotation.Timed
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import org.springframework.util.StringUtils.hasText

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Service
class EnvironmentStageService @Autowired()(environmentStageRepository: EnvironmentStageRepository) extends Logging {

  @Timed
  def searchStages(environmentStageFilters: EnvironmentStageFilters): JList[EnvironmentStage] = {
    environmentStageRepository.search(environmentStageFilters, defaultPage).asJava
  }

  @Timed
  def findStageById(environmentStageId: String): EnvironmentStage = {
    environmentStageRepository.findById(environmentStageId)
  }

  @Timed
  def findStageByTitle(environmentStageTitle: String): EnvironmentStage = {
    environmentStageRepository.findByTitle(environmentStageTitle)
  }

  @Timed
  def createStage(environmentStage: EnvironmentStage): EnvironmentStage = {
    logger.debug("Creating a new environment stage")
    validateTitle(environmentStage)
    environmentStageRepository.create(environmentStage)
  }

  @Timed
  def updateStage(environmentStage: EnvironmentStage): EnvironmentStage = {
    logger.debug(s"Updating environment stage [$environmentStage]")
    checkArgument(hasText(environmentStage.getId), "ID is required")
    validateTitle(environmentStage)
    environmentStageRepository.update(environmentStage)
  }

  @Timed
  def deleteStage(environmentStageId: String): Unit = {
    logger.debug(s"Deleting environment stage [$environmentStageId]")
    environmentStageRepository.delete(environmentStageId)
  }

  private def validateTitle(environmentStage: EnvironmentStage): Unit = {
    checkArgument(hasText(environmentStage.getTitle), "Title cannot be blank")
  }
}
