/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import io.micrometer.core.annotation.Timed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\u0007\u000f\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tO\u0001\u0011)\u0019!C\u0001Q!Aq\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003F\u0001\u0011\u0005a\tC\u0003o\u0001\u0011\u0005q\u000eC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003\u007f\u0001A\u0011BA!\u0005I\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u000b\u0005=\u0001\u0012aB:feZL7-\u001a\u0006\u0003#I\tA\"\u001a8wSJ|g.\\3oiNT!a\u0005\u000b\u0002\u0013ad'/\u001a7fCN,'BA\u000b\u0017\u0003%AXMY5bY\u0006\u00147OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\u0016CB\u0004H.[2bi&|gNU3q_NLGo\u001c:z!\t\u0011S%D\u0001$\u0015\t!\u0003#\u0001\u0006sKB|7/\u001b;pefL!AJ\u0012\u0003+\u0005\u0003\b\u000f\\5dCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006AQM^3oi\n+8/F\u0001*!\tQS&D\u0001,\u0015\ta##\u0001\u0004fm\u0016tGo]\u0005\u0003]-\u0012\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004eQ*\u0004CA\u001a\u0001\u001b\u0005q\u0001\"\u0002\u0011\u0005\u0001\u0004\t\u0003\"B\u0014\u0005\u0001\u0004I\u0003F\u0001\u00038!\tA4)D\u0001:\u0015\tQ4(\u0001\u0006b]:|G/\u0019;j_:T!\u0001P\u001f\u0002\u000f\u0019\f7\r^8ss*\u0011ahP\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0001\u0006\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011K$!C!vi><\u0018N]3e\u0003I\u0019X-\u0019:dQ\u0006\u0003\b\u000f\\5dCRLwN\\:\u0015\u0005\u001d3\u0006c\u0001%N\u001f6\t\u0011J\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\t1K7\u000f\u001e\t\u0003!Rk\u0011!\u0015\u0006\u0003#IS!a\u0015\n\u0002\r\u0011|W.Y5o\u0013\t)\u0016KA\u0006BaBd\u0017nY1uS>t\u0007\"B,\u0006\u0001\u0004A\u0016AE1qa2L7-\u0019;j_:4\u0015\u000e\u001c;feN\u0004\"!\u00171\u000e\u0003iS!a\u0017/\u0002\r\u0019LG\u000e^3s\u0015\tif,\u0001\u0002wc)\u0011qLE\u0001\u0004CBL\u0017BA1[\u0005I\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8GS2$XM]:)\u0005\u0015\u0019\u0007C\u00013m\u001b\u0005)'B\u0001\u001eg\u0015\t9\u0007.\u0001\u0003d_J,'BA5k\u0003)i\u0017n\u0019:p[\u0016$XM\u001d\u0006\u0002W\u0006\u0011\u0011n\\\u0005\u0003[\u0016\u0014Q\u0001V5nK\u0012\f1CZ5oI\u0006\u0003\b\u000f\\5dCRLwN\u001c\"z\u0013\u0012$\"a\u00149\t\u000bE4\u0001\u0019\u0001:\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e!\t\u0019(P\u0004\u0002uqB\u0011Q\u000fH\u0007\u0002m*\u0011q\u000fG\u0001\u0007yI|w\u000e\u001e \n\u0005ed\u0012A\u0002)sK\u0012,g-\u0003\u0002|y\n11\u000b\u001e:j]\u001eT!!\u001f\u000f)\u0005\u0019\u0019\u0017!E2sK\u0006$X-\u00119qY&\u001c\u0017\r^5p]R\u0019q*!\u0001\t\r\u0005\rq\u00011\u0001P\u0003-\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8)\u0005\u001d\u0019\u0017!E;qI\u0006$X-\u00119qY&\u001c\u0017\r^5p]R\u0019q*a\u0003\t\r\u0005\r\u0001\u00021\u0001PQ\tA1-A\teK2,G/Z!qa2L7-\u0019;j_:$B!a\u0005\u0002\u001aA\u00191$!\u0006\n\u0007\u0005]AD\u0001\u0003V]&$\b\"B9\n\u0001\u0004\u0011\bFA\u0005d\u0003\u0019:W\r^!qa2L7-\u0019;j_:\u001cH)\u001a9m_f\f'\r\\3P]\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0004\u000f\u0006\u0005\u0002BBA\u0012\u0015\u0001\u0007!/A\u0007f]ZL'o\u001c8nK:$\u0018\n\u001a\u0015\u0003\u0015\r\f\u0011CZ5oI\nKXI\u001c<je>tW.\u001a8u)\u0011\tY#a\u000f\u0011\u000b\u00055\u0012q\u0007:\u000f\t\u0005=\u00121\u0007\b\u0004k\u0006E\u0012\"A\u000f\n\u0007\u0005UB$A\u0004qC\u000e\\\u0017mZ3\n\u00079\u000bIDC\u0002\u00026qAa!a\t\f\u0001\u0004\u0011\bFA\u0006d\u000351\u0018\r\\5eCR,G+\u001b;mKR!\u00111CA\"\u0011\u0019\t\u0019\u0001\u0004a\u0001\u001f\"\u001a\u0001!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014@\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003#\nYEA\u0004TKJ4\u0018nY3")
public class ApplicationService {
    private final ApplicationRepository applicationRepository;
    private final XLReleaseEventBus eventBus;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public java.util.List<Application> searchApplications(ApplicationFilters applicationFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.applicationRepository.searchApplications(applicationFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Application findApplicationById(String applicationId) {
        Application application = this.applicationRepository.findApplicationById(applicationId);
        return application;
    }

    @Timed
    public Application createApplication(Application application) {
        this.validateTitle(application);
        Application createdApplication = this.applicationRepository.createApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationCreatedEvent(createdApplication));
        return createdApplication;
    }

    @Timed
    public Application updateApplication(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validateTitle(application);
        Application updatedApplication = this.applicationRepository.updateApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationUpdatedEvent(updatedApplication));
        return updatedApplication;
    }

    @Timed
    public void deleteApplication(String applicationId) {
        Application application = this.applicationRepository.findApplicationById(applicationId);
        this.applicationRepository.deleteApplication(applicationId);
        this.eventBus().publish((XLReleaseEvent)new ApplicationDeletedEvent(application));
    }

    @Timed
    public java.util.List<Application> getApplicationsDeployableOnEnvironment(String environmentId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.applicationRepository.getApplicationsDeployableOnEnvironment(environmentId)).asJava();
    }

    @Timed
    public List<String> findByEnvironment(String environmentId) {
        return this.applicationRepository.findByEnvironment(environmentId);
    }

    private void validateTitle(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    @Autowired
    public ApplicationService(ApplicationRepository applicationRepository, XLReleaseEventBus eventBus) {
        this.applicationRepository = applicationRepository;
        this.eventBus = eventBus;
    }
}

