/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationEnvironmentFilterScope;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\t\u0012\u0001qA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011)\u0019!C\u0001g!A!\b\u0001B\u0001B\u0003%A\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003w\u0001A\u0011AA\u001f\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002X\u0001!I!!\u0017\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\t\u0011RI\u001c<je>tW.\u001a8u'\u0016\u0014h/[2f\u0015\t\u00112#A\u0004tKJ4\u0018nY3\u000b\u0005Q)\u0012\u0001D3om&\u0014xN\\7f]R\u001c(B\u0001\f\u0018\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u00193\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00025\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g!\t!\u0013&D\u0001&\u0015\t1s%A\u0003tY\u001a$$NC\u0001)\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0016&\u0005\u001daunZ4j]\u001e\fQ#\u001a8wSJ|g.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002.a5\taF\u0003\u00020'\u0005Q!/\u001a9pg&$xN]=\n\u0005Er#!F#om&\u0014xN\\7f]R\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgV\tA\u0007\u0005\u00026q5\taG\u0003\u00028+\u00051QM^3oiNL!!\u000f\u001c\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u00051A(\u001b8jiz\"2!P A!\tq\u0004!D\u0001\u0012\u0011\u0015YC\u00011\u0001-\u0011\u0015\u0011D\u00011\u00015Q\t!!\t\u0005\u0002D\u001d6\tAI\u0003\u0002F\r\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u001dC\u0015a\u00024bGR|'/\u001f\u0006\u0003\u0013*\u000bQAY3b]NT!a\u0013'\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!T\u0001\u0004_J<\u0017BA(E\u0005%\tU\u000f^8xSJ,G-\u0001\ntK\u0006\u00148\r[#om&\u0014xN\\7f]R\u001cHC\u0001*b!\r\u0019\u0006LW\u0007\u0002)*\u0011QKV\u0001\u0005kRLGNC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&\u0001\u0002'jgR\u0004\"aW0\u000e\u0003qS!\u0001F/\u000b\u0005y+\u0012A\u00023p[\u0006Lg.\u0003\u0002a9\nYQI\u001c<je>tW.\u001a8u\u0011\u0015\u0011W\u00011\u0001d\u0003I)gN^5s_:lWM\u001c;GS2$XM]:\u0011\u0005\u0011\\W\"A3\u000b\u0005\u0019<\u0017A\u00024jYR,'O\u0003\u0002iS\u0006\u0011a/\r\u0006\u0003UV\t1!\u00199j\u0013\taWM\u0001\nF]ZL'o\u001c8nK:$h)\u001b7uKJ\u001c\bFA\u0003o!\tyw/D\u0001q\u0015\t)\u0015O\u0003\u0002sg\u0006!1m\u001c:f\u0015\t!X/\u0001\u0006nS\u000e\u0014x.\\3uKJT\u0011A^\u0001\u0003S>L!\u0001\u001f9\u0003\u000bQKW.\u001a3\u0002'\u0019Lg\u000eZ#om&\u0014xN\\7f]R\u0014\u00150\u00133\u0015\u0005i[\b\"\u0002?\u0007\u0001\u0004i\u0018!D3om&\u0014xN\\7f]RLE\rE\u0002\u007f\u0003\u0017q1a`A\u0004!\r\t\taH\u0007\u0003\u0003\u0007Q1!!\u0002\u001c\u0003\u0019a$o\\8u}%\u0019\u0011\u0011B\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tIa\b\u0015\u0003\r9\faCZ5oI\u0016sg/\u001b:p]6,g\u000e\u001e\"z)&$H.\u001a\u000b\u00045\u0006]\u0001\"\u0002?\b\u0001\u0004i\bFA\u0004o\u0003E\u0019'/Z1uK\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u00045\u0006}\u0001BBA\u0011\u0011\u0001\u0007!,A\u0006f]ZL'o\u001c8nK:$\bF\u0001\u0005o\u0003E)\b\u000fZ1uK\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u00045\u0006%\u0002BBA\u0011\u0013\u0001\u0007!\f\u000b\u0002\n]\u0006\tB-\u001a7fi\u0016,eN^5s_:lWM\u001c;\u0015\t\u0005E\u0012q\u0007\t\u0004=\u0005M\u0012bAA\u001b?\t!QK\\5u\u0011\u0015a(\u00021\u0001~Q\tQa.A\rva\u0012\fG/\u001a'bE\u0016dW\rZ#om&\u0014xN\\7f]R\u001cHCBA\u0019\u0003\u007f\tI\u0005C\u0004\u0002B-\u0001\r!a\u0011\u0002\u000b1\f'-\u001a7\u0011\u0007m\u000b)%C\u0002\u0002Hq\u0013\u0001#\u00128wSJ|g.\\3oi2\u000b'-\u001a7\t\u000bQY\u0001\u0019\u0001*\u0002/\u0019Lg\u000eZ#om&\u0014xN\\7f]R\u001c()\u001f'bE\u0016dGc\u0001*\u0002P!9\u0011\u0011\t\u0007A\u0002\u0005\r\u0013\u0001\u0003<bY&$\u0017\r^3\u0015\t\u0005E\u0012Q\u000b\u0005\u0007\u0003Ci\u0001\u0019\u0001.\u0002\u001bY\fG.\u001b3bi\u0016$\u0016\u000e\u001e7f)\u0011\t\t$a\u0017\t\r\u0005\u0005b\u00021\u0001[\u0003M1\u0018\r\\5eCR,G)Z:de&\u0004H/[8o)\u0011\t\t$!\u0019\t\r\u0005\u0005r\u00021\u0001[Q\r\u0001\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e&\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002p\u0005%$aB*feZL7-\u001a")
public class EnvironmentService
implements Logging {
    private final EnvironmentRepository environmentRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentService environmentService = this;
        synchronized (environmentService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public java.util.List<Environment> searchEnvironments(EnvironmentFilters environmentFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentRepository.searchEnvironments(environmentFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Environment findEnvironmentById(String environmentId) {
        return this.environmentRepository.findEnvironmentById(environmentId);
    }

    @Timed
    public Environment findEnvironmentByTitle(String environmentId) {
        return this.environmentRepository.findEnvironmentByTitle(environmentId);
    }

    @Timed
    public Environment createEnvironment(Environment environment) {
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment");
        this.validate(environment);
        Environment created = this.environmentRepository.createEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentCreatedEvent(created));
        return created;
    }

    @Timed
    public Environment updateEnvironment(Environment environment) {
        this.logger().debug((Function0 & Serializable)() -> "Updating environment [" + environment + "]");
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environment);
        Environment updated = this.environmentRepository.updateEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentUpdatedEvent(environment));
        return updated;
    }

    @Timed
    public void deleteEnvironment(String environmentId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting environment [" + environmentId + "]");
        Environment environment = this.environmentRepository.findEnvironmentById(environmentId);
        this.environmentRepository.deleteEnvironment(environmentId);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentDeletedEvent(environment));
    }

    public void updateLabeledEnvironments(EnvironmentLabel label, java.util.List<Environment> environments) {
        environments.forEach(environment -> {
            environment.setLabels(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(environment.getLabels()).asScala().filter((Function1 & Serializable)lbl -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$updateLabeledEnvironments$2(label, lbl)))).asJava());
            this.updateEnvironment((Environment)environment);
        });
    }

    public java.util.List<Environment> findEnvironmentsByLabel(EnvironmentLabel label) {
        EnvironmentFilters filter = new EnvironmentFilters();
        filter.setLabels(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)label.getTitle(), (List)Nil$.MODULE$)).asJava());
        filter.setScope(ApplicationEnvironmentFilterScope.GLOBAL_AND_FOLDER);
        return this.searchEnvironments(filter);
    }

    private void validate(Environment environment) {
        this.validateTitle(environment);
        this.validateDescription(environment);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environment.getStage()).exists((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$validate$1(stage))), (String)"Environment stage ID is required", (Object[])new Object[0]);
    }

    private void validateTitle(Environment environment) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateDescription(Environment environment) {
        if (environment.getDescription() != null) {
            Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Description cannot be blank", (Object[])new Object[0]);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateLabeledEnvironments$2(EnvironmentLabel label$1, EnvironmentLabel lbl) {
        return lbl.getTitle() != label$1.getTitle();
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(EnvironmentStage stage) {
        return StringUtils.hasText((String)stage.getId());
    }

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, XLReleaseEventBus eventBus) {
        this.environmentRepository = environmentRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

