import React from 'react';
import { ReactWrapper } from 'enzyme';
import { ApplicationFormComponent } from './application-form-component';
import WidgetLinkedEnvironments from '../../../../../../../../main/resources/web/include/components/shared/widgets/widget-linked-environments.js';
import { formApplications, formEnvironments, formStages } from '../../__mocks__/application-list.mocks';
import { mountWithStoreAndTheme } from '@xlr-ui/tests/unit/testing-utils';
import { Application } from '../../../../application-list.types';
import { DotInputText } from '@digital-ai/dot-components';

describe('Application edit environment sidebar component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const beginState = {
        applicationList: {
            applications: formApplications,
            deleteModalIsOpen: false,
        },
        folderId: '',
        applicationForm: {
            stages: formStages,
            environments: formEnvironments,
            application: formApplications[0],
            applications: formApplications,
        },
    };
    const onFormChange = jest.fn();
    const onPristinityChange = jest.fn();
    const onValidationChange = jest.fn();

    const mount = (application: Application = formApplications[0]) => {
        wrapper = mountWithStoreAndTheme(
            <ApplicationFormComponent
                {...{ applicationList: formApplications, applicationModel: application, onFormChange, onPristinityChange, onValidationChange }}
            />,
            dispatch,
            { ...beginState },
        );
    };

    beforeEach(() => {
        mount();
    });

    it('should render properly with application', () => {
        const subtitle = wrapper.find('.application-edit-form h4');
        expect(subtitle.text()).toBe('Applications / App1');
        const appName = wrapper.find(DotInputText).find('input');
        expect(appName.props().value).toBe('App1');
        const environmentsLinked = wrapper.find('ListBlock');
        expect(environmentsLinked).toHaveLength(1);
        expect(environmentsLinked.text()).toContain('my environment');
    });

    it('should render properly without application', () => {
        mount({} as never);
        const subtitle = wrapper.find('.application-edit-form h4');
        expect(subtitle.text()).toBe('Applications / New Application');
        const appName = wrapper.find(DotInputText).find('input');
        expect(appName.props().value).toBe('');
        const environmentsLinked = wrapper.find('ListBlock');
        expect(environmentsLinked).toHaveLength(0);
    });

    it('should not allow 2 applications with same name', (done) => {
        const nameForm = () => wrapper.find(DotInputText);
        nameForm()
            .find('input')
            .simulate('change', { target: { value: 'App2' } });
        expect(nameForm().find('input')).toHaveValue('App2');
        setTimeout(() => {
            expect(nameForm().find('p').text()).toBe('Application already exists.');
            expect(onValidationChange).toHaveBeenCalledWith(false);
            done();
        }, 500);
    });

    it('should handle the callbacks', () => {
        // should update just the title
        wrapper.find(DotInputText).invoke('onChange')?.({ target: { value: 'my new application' } } as never);
        const updatedApp = formApplications[0];
        updatedApp.title = 'my new application';
        expect(onFormChange).toHaveBeenCalledWith(updatedApp);
        onFormChange.mockClear();

        //should remove environment from application
        const environmentsLinked = wrapper.find(WidgetLinkedEnvironments);
        environmentsLinked.props().onDelete(formApplications[0].environments[0]);
        expect(onFormChange).toHaveBeenCalledWith({ id: 'Application1', title: 'my new application', folderId: '', environments: [] });
        expect(onValidationChange).toHaveBeenCalledWith(true);
    });
});
