import React from 'react';
import { Provider } from 'react-redux';
import { store } from '../../../store/environment-management-store';
import { EnvironmentEditPageComponent } from './environment-edit-page-component';

export const EnvironmentEditPage: React.FC<{ environmentId: string; folderId: string }> = ({ folderId, environmentId }) => {
    return (
        <Provider store={store}>
            <EnvironmentEditPageComponent environmentId={environmentId} folderId={folderId} />
        </Provider>
    );
};
