/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.xlrelease.api.v1.ApplicationApi;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.api.v1.form.ApplicationForm;
import com.xebialabs.xlrelease.api.v1.views.ApplicationView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.service.ApplicationSecurity;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import io.micrometer.core.annotation.Timed;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ApplicationApiImpl
implements ApplicationApi {
    private final ApplicationService applicationService;
    private final ApplicationSecurity applicationSecurity;

    @Autowired
    public ApplicationApiImpl(ApplicationService applicationService, ApplicationSecurity applicationSecurity) {
        this.applicationService = applicationService;
        this.applicationSecurity = applicationSecurity;
    }

    @Timed
    public ApplicationView createApplication(ApplicationForm applicationForm) {
        this.applicationSecurity.checkCreate();
        return ApplicationView.fromApplication((Application)this.applicationService.createApplication(applicationForm.toApplication()));
    }

    @Timed
    public ApplicationView getApplication(String applicationId) {
        this.applicationSecurity.checkView();
        return ApplicationView.fromApplication((Application)this.applicationService.findApplicationById(applicationId));
    }

    @Timed
    public ApplicationView updateApplication(String applicationId, ApplicationForm applicationForm) {
        this.applicationSecurity.checkEdit();
        Application application = applicationForm.toApplication();
        application.setId(applicationId);
        return ApplicationView.fromApplication((Application)this.applicationService.updateApplication(application));
    }

    @Timed
    public List<ApplicationView> searchApplications(ApplicationFilters applicationFilters) {
        this.applicationSecurity.checkView();
        return this.applicationService.searchApplications(applicationFilters).stream().map(ApplicationView::fromApplication).collect(Collectors.toList());
    }

    @Timed
    public void deleteApplication(String applicationId) {
        this.applicationSecurity.checkEdit();
        this.applicationService.deleteApplication(applicationId);
    }

    @Timed
    public Application create(Application application) {
        this.applicationSecurity.checkCreate();
        return this.applicationService.createApplication(application);
    }

    @Timed
    public Application getById(String applicationId) {
        this.applicationSecurity.checkView();
        return this.applicationService.findApplicationById(applicationId);
    }

    @Timed
    public Application update(Application application) {
        this.applicationSecurity.checkEdit();
        return this.applicationService.updateApplication(application);
    }

    @Timed
    public List<Application> search(ApplicationFilters filters) {
        this.applicationSecurity.checkView();
        return this.applicationService.searchApplications(filters);
    }
}

