import React from 'react';

import { EnvironmentListComponent } from './environment-list-component';
import { EnvironmentListItemComponent } from './environment-list-item-component';
import { NoData } from '@xlr-ui/app/react/components';
import { mountComponentWithStore, preparePortalContainer, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { env, envStateWithModel, stageList } from '../__mocks__/environment-list.mocks';
import { RootState } from '@xlr-ui/app/js/store.types';
import { DotConfirmationDialog } from '@digital-ai/dot-components';
import { environmentLists } from '../ducks/environment-list.reducer';
import { EnvironmentListHeaderComponent } from './environment-list-header-component';

const { initEnvironmentList, deleteEnvironment } = environmentLists.actions;

describe('Environment list component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const folderId = '';

    const mount = (folder: string = folderId, state: RootState = envStateWithModel) => {
        wrapper = mountComponentWithStore(<EnvironmentListComponent folderId={folder} />, dispatch, state);
    };

    beforeEach(() => {
        preparePortalContainer();
    });

    it('should render a list of child rows if there are environments', () => {
        mount();
        expect(wrapper.find(EnvironmentListHeaderComponent)).toExist();
        expect(wrapper.find(EnvironmentListItemComponent).length).toBe(6);
        expect(wrapper.find('h4').text()).toBe('Environments (6)');
        expect(wrapper.find(NoData).length).toBe(0);
    });

    it('should not render if no environments', () => {
        mount('', {
            ...envStateWithModel,
            environmentList: {
                environments: [],
                stages: stageList,
            },
        });
        expect(wrapper.find(EnvironmentListItemComponent).length).toBe(0);
        expect(wrapper.find('h4').text()).toBe('Environments (0)');
        expect(wrapper.find(NoData).length).toBe(1);
    });

    it('should dispatch delete', () => {
        mount();
        expect(dispatch).toBeCalledWith(initEnvironmentList(folderId));
        const item = wrapper.find(EnvironmentListItemComponent).at(0);
        const deleteBtn = item.find('span[data-test="delete-action"]');
        deleteBtn.simulate('click');
        expect(wrapper.find(DotConfirmationDialog)).toExist();
        wrapper.find(DotConfirmationDialog).invoke('onSubmit')();
        expect(dispatch).toBeCalledWith(deleteEnvironment(env));
    });
});
